/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.network;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.capability.InventoryListDataProvider;
import studio.fantasyit.maid_storage_manager.data.BindingData;
import studio.fantasyit.maid_storage_manager.data.InScreenTipData;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.data.InventoryListDataClient;
import studio.fantasyit.maid_storage_manager.integration.create.StockManagerInteract;
import studio.fantasyit.maid_storage_manager.integration.request.IngredientRequest;
import studio.fantasyit.maid_storage_manager.items.CraftGuide;
import studio.fantasyit.maid_storage_manager.items.LogisticsGuide;
import studio.fantasyit.maid_storage_manager.items.ProgressPad;
import studio.fantasyit.maid_storage_manager.items.StorageDefineBauble;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.menu.FilterMenu;
import studio.fantasyit.maid_storage_manager.menu.ItemSelectorMenu;
import studio.fantasyit.maid_storage_manager.menu.LogisticsGuideMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.network.ClientInputPacket;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.network.CreateStockManagerPacket;
import studio.fantasyit.maid_storage_manager.network.DebugDataPacket;
import studio.fantasyit.maid_storage_manager.network.ItemSelectorGuiPacket;
import studio.fantasyit.maid_storage_manager.network.ItemSelectorSetItemPacket;
import studio.fantasyit.maid_storage_manager.network.JEIRequestPacket;
import studio.fantasyit.maid_storage_manager.network.JEIRequestResultPacket;
import studio.fantasyit.maid_storage_manager.network.MaidDataSyncPacket;
import studio.fantasyit.maid_storage_manager.network.MaidDataSyncToClientPacket;
import studio.fantasyit.maid_storage_manager.network.PartialInventoryListData;
import studio.fantasyit.maid_storage_manager.network.ProgressPadUpdatePacket;
import studio.fantasyit.maid_storage_manager.network.RenderEntityPacket;
import studio.fantasyit.maid_storage_manager.network.ShowCommonPacket;
import studio.fantasyit.maid_storage_manager.network.ShowInvPacket;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;

public class Network {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("maid_storage_manager", "go_target"), () -> "1", v -> true, v -> true);

    public static void sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType type, int key, int value) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new ItemSelectorGuiPacket(type, key, value));
    }

    public static void sendItemSelectorSetItemPacket(List<Pair<Integer, ItemStack>> list) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new ItemSelectorSetItemPacket(list));
    }

    public static void sendItemSelectorSetItemPacket(Integer slot, ItemStack item) {
        Network.sendItemSelectorSetItemPacket(List.of(Pair.of((Object)slot, (Object)item)));
    }

    public static void sendRequestListPacket(UUID uuid) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new PartialInventoryListData(uuid, List.of()));
    }

    public static void sendMaidDataSync(MaidDataSyncPacket.Type type, int id, int value) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new MaidDataSyncPacket(type, id, value));
    }

    public static void sendShowInvPacket(ServerPlayer player, InventoryItem item, int time) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ShowInvPacket(item, time));
    }

    private static void registerMessage() {
        INSTANCE.registerMessage(0, ItemSelectorGuiPacket.class, ItemSelectorGuiPacket::toBytes, ItemSelectorGuiPacket::new, (msg, context) -> {
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$4((Supplier)context, msg));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(1, ItemSelectorSetItemPacket.class, ItemSelectorSetItemPacket::toBytes, ItemSelectorSetItemPacket::new, (msg, context) -> {
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$8((Supplier)context, msg));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(2, DebugDataPacket.class, DebugDataPacket::toBytes, DebugDataPacket::new, (msg, context) -> {
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> {
                if (!Config.enableDebug) {
                    return;
                }
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)msg.data));
                }
            });
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(3, PartialInventoryListData.class, PartialInventoryListData::toBytes, PartialInventoryListData::new, (msg, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$13((Supplier)context, msg)));
        INSTANCE.registerMessage(4, ClientInputPacket.class, ClientInputPacket::toBytes, ClientInputPacket::new, (msg, context) -> {
            NetworkEvent.Context context1 = (NetworkEvent.Context)context.get();
            context1.enqueueWork(() -> Network.lambda$registerMessage$15(context1, msg, (Supplier)context));
        });
        INSTANCE.registerMessage(5, MaidDataSyncPacket.class, MaidDataSyncPacket::toBytes, MaidDataSyncPacket::new, (msg, context) -> {
            @Nullable ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            Entity entity = sender.m_9236_().m_6815_(msg.id);
            if (entity instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entity;
                if (msg.type == MaidDataSyncPacket.Type.MemoryAssistant) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.memoryAssistant(StorageManagerConfigData.MemoryAssistant.values()[msg.value]);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.NoPlaceSort) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.noSortPlacement(msg.value == 1);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.CoWork) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.coWorkMode(msg.value == 1);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.AllowSeekWorkMeal) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.allowSeekWorkMeal(msg.value == 1);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.FastSort) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.suppressStrategy(StorageManagerConfigData.SuppressStrategy.values()[msg.value]);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.MemorizeCraftGuide) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.useMemorizedCraftGuide(msg.value == 1);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.MaxParallel) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.maxParallel(msg.value);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.CraftingRepeatCount) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.maxCraftingLayerRepeatCount(msg.value);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.AutoSorting) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.autoSorting(msg.value != 0);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                } else if (msg.type == MaidDataSyncPacket.Type.ItemTypeLimit) {
                    StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
                    data.itemTypeLimit(msg.value);
                    maid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
                }
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(6, CraftGuideGuiPacket.class, CraftGuideGuiPacket::toBytes, CraftGuideGuiPacket::new, (msg, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$18((Supplier)context, msg)));
        INSTANCE.registerMessage(7, RenderEntityPacket.class, RenderEntityPacket::toBytes, RenderEntityPacket::new, (msg, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$20(msg, (Supplier)context)));
        INSTANCE.registerMessage(8, ShowInvPacket.class, ShowInvPacket::toBytes, ShowInvPacket::new, (msg, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$22(msg, (Supplier)context)));
        INSTANCE.registerMessage(9, JEIRequestPacket.class, JEIRequestPacket::toBytes, JEIRequestPacket::new, (msg, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$24((Supplier)context, msg)));
        INSTANCE.registerMessage(10, JEIRequestResultPacket.class, JEIRequestResultPacket::toBytes, JEIRequestResultPacket::new, (msg, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$26(msg, (Supplier)context)));
        INSTANCE.registerMessage(11, MaidDataSyncToClientPacket.class, MaidDataSyncToClientPacket::toBytes, MaidDataSyncToClientPacket::new, (msg, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$28(msg, (Supplier)context)));
        INSTANCE.registerMessage(12, CreateStockManagerPacket.class, CreateStockManagerPacket::toBytes, CreateStockManagerPacket::new, (packet, context) -> ((NetworkEvent.Context)context.get()).enqueueWork(() -> Network.lambda$registerMessage$30((Supplier)context, packet)));
        INSTANCE.registerMessage(13, ProgressPadUpdatePacket.class, ProgressPadUpdatePacket::toNetwork, ProgressPadUpdatePacket::new, (p, c) -> ((NetworkEvent.Context)c.get()).enqueueWork(() -> Network.lambda$registerMessage$32(p, (Supplier)c)));
        INSTANCE.registerMessage(14, ShowCommonPacket.class, ShowCommonPacket::toBytes, ShowCommonPacket::new, (p, c) -> ((NetworkEvent.Context)c.get()).enqueueWork(() -> Network.lambda$registerMessage$34(p, (Supplier)c)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Player getLocalPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    private static /* synthetic */ void lambda$registerMessage$34(ShowCommonPacket p, Supplier c) {
        ShowCommonPacket.handle(p);
        ((NetworkEvent.Context)c.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$32(ProgressPadUpdatePacket p, Supplier c) {
        ProgressPadUpdatePacket.handle(p);
        ((NetworkEvent.Context)c.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$30(Supplier context, CreateStockManagerPacket packet) {
        Entity target;
        @Nullable ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
        if (sender != null && (target = sender.m_9236_().m_6815_(packet.id)) instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)target;
            if (packet.data == CreateStockManagerPacket.Type.OPEN_SCREEN) {
                StockManagerInteract.onHandleStockManager(sender, maid, packet.ticker);
            } else if (packet.data == CreateStockManagerPacket.Type.SHOP_LIST) {
                StockManagerInteract.onHandleShoppingList(sender, maid, packet.ticker);
            }
        }
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$28(MaidDataSyncToClientPacket msg, Supplier context) {
        Player sender = Network.getLocalPlayer();
        Entity patt18893$temp = sender.m_9236_().m_6815_(msg.id);
        if (patt18893$temp instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)patt18893$temp;
            if (msg.type == MaidDataSyncToClientPacket.Type.WORKING) {
                maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.CURRENTLY_WORKING.get(), (Object)ScheduleBehavior.Schedule.values()[msg.value.m_128451_("id")]);
            } else if (msg.type == MaidDataSyncToClientPacket.Type.BAUBLE) {
                maid.getMaidBauble().deserializeNBT(msg.value);
            }
        }
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$26(JEIRequestResultPacket msg, Supplier context) {
        InScreenTipData.show(msg.result, 5.0f);
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$24(Supplier context, JEIRequestPacket msg) {
        ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
        if (sender == null) {
            return;
        }
        IngredientRequest.onRequest(sender, msg.data, msg.targetMaidId);
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$22(ShowInvPacket msg, Supplier context) {
        InventoryListDataClient.setShowingInv(msg.data, msg.time);
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$20(RenderEntityPacket msg, Supplier context) {
        BindingData.setEntityIds(msg.entityIds);
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$18(Supplier context, CraftGuideGuiPacket msg) {
        AbstractContainerMenu patt16225$temp;
        @Nullable ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
        if (sender == null) {
            sender = Network.getLocalPlayer();
        }
        if ((patt16225$temp = sender.f_36096_) instanceof ICraftGuiPacketReceiver) {
            ICraftGuiPacketReceiver icgpr = (ICraftGuiPacketReceiver)patt16225$temp;
            icgpr.handleGuiPacket(msg.type, msg.key, msg.value, msg.data);
        }
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$15(NetworkEvent.Context context1, ClientInputPacket msg, Supplier context) {
        ServerPlayer sender = context1.getSender();
        if (sender != null) {
            ItemStack item = sender.m_21120_(InteractionHand.MAIN_HAND);
            if (item.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) && msg.type == ClientInputPacket.Type.SCROLL) {
                CraftGuide.rollMode(item, sender, msg.value > 0 ? -1 : 1);
            } else if (item.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) && msg.type == ClientInputPacket.Type.ALT_SCROLL) {
                CraftGuide.rollSpecial(item, sender, msg.value > 0 ? -1 : 1);
            } else if (item.m_150930_((Item)ItemRegistry.STORAGE_DEFINE_BAUBLE.get()) && msg.type == ClientInputPacket.Type.SCROLL) {
                StorageDefineBauble.rollMode(item, sender, msg.value > 0 ? -1 : 1);
            } else if (item.m_150930_((Item)ItemRegistry.LOGISTICS_GUIDE.get()) && msg.type == ClientInputPacket.Type.SCROLL) {
                LogisticsGuide.rollMode(item, sender, msg.value > 0 ? -1 : 1);
            } else if (item.m_150930_((Item)ItemRegistry.PROGRESS_PAD.get())) {
                if (msg.type == ClientInputPacket.Type.SCROLL) {
                    ProgressPad.rollValue(item, sender, msg.value > 0 ? -1 : 1);
                } else {
                    ProgressPad.rollSelecting(item, sender, msg.value > 0 ? -1 : 1);
                }
            }
        }
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$13(Supplier context, PartialInventoryListData msg) {
        if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
            InventoryListDataClient.getInstance().patch(msg.key, msg.data);
        } else {
            ((NetworkEvent.Context)context.get()).getSender().m_20194_().m_129783_().getCapability(InventoryListDataProvider.INVENTORY_LIST_DATA_CAPABILITY).ifPresent(arg_0 -> Network.lambda$registerMessage$12(msg, (Supplier)context, arg_0));
        }
        ((NetworkEvent.Context)context.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$registerMessage$12(PartialInventoryListData msg, Supplier context, InventoryListDataProvider.InventoryListData inventoryListData) {
        inventoryListData.sendTo(msg.key, ((NetworkEvent.Context)context.get()).getSender());
    }

    private static /* synthetic */ void lambda$registerMessage$8(Supplier context, ItemSelectorSetItemPacket msg) {
        AbstractContainerMenu patt6039$temp;
        AbstractContainerMenu patt5726$temp;
        ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
        if (sender != null && (patt5726$temp = sender.f_36096_) instanceof ItemSelectorMenu) {
            ItemSelectorMenu ism = (ItemSelectorMenu)patt5726$temp;
            msg.items.forEach(p -> ism.filteredItems.m_6836_((Integer)p.getLeft(), (ItemStack)p.getRight()));
            ism.save();
            ism.m_38946_();
        } else if (sender != null && (patt6039$temp = sender.f_36096_) instanceof FilterMenu) {
            FilterMenu ism = (FilterMenu)patt6039$temp;
            msg.items.forEach(p -> ism.filteredItems.m_6836_((Integer)p.getLeft(), (ItemStack)p.getRight()));
            ism.save();
            ism.m_38946_();
        }
    }

    private static /* synthetic */ void lambda$registerMessage$4(Supplier context, ItemSelectorGuiPacket msg) {
        ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
        if (sender == null) {
            return;
        }
        AbstractContainerMenu patt4707$temp = sender.f_36096_;
        if (patt4707$temp instanceof ItemSelectorMenu) {
            ItemSelectorMenu ism = (ItemSelectorMenu)patt4707$temp;
            ism.handleUpdate(msg.type, msg.key, msg.value);
        } else {
            AbstractContainerMenu patt4876$temp = sender.f_36096_;
            if (patt4876$temp instanceof FilterMenu) {
                FilterMenu ifm = (FilterMenu)patt4876$temp;
                ifm.handleUpdate(msg.type, msg.key, msg.value);
            } else {
                AbstractContainerMenu patt5039$temp = sender.f_36096_;
                if (patt5039$temp instanceof LogisticsGuideMenu) {
                    LogisticsGuideMenu lgm = (LogisticsGuideMenu)patt5039$temp;
                    lgm.handleUpdate(msg.type, msg.key, msg.value);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void FMLClientSetupEvent(FMLClientSetupEvent event) {
            Network.registerMessage();
        }
    }

    @Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.DEDICATED_SERVER})
    public static class Server {
        @SubscribeEvent
        public static void FMLClientSetupEvent(FMLDedicatedServerSetupEvent event) {
            Network.registerMessage();
        }
    }
}

