/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.view;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.advancement.AdvancementTypes;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.base.MaidMoveToBlockTaskWithArrivalMap;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StoragePredictor;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.PosUtil;

public class ViewMoveBehavior
extends MaidMoveToBlockTaskWithArrivalMap {
    Target chestPos = null;

    public ViewMoveBehavior() {
        super((float)Config.viewSpeed, 3);
        this.verticalSearchStart = 1;
        this.setMaxCheckRate(100);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getViewedInventory(owner).getMarkChanged().isEmpty() && !super.checkExtraStartConditions(worldIn, owner)) {
            return false;
        }
        return MemoryUtil.getCurrentlyWorking(owner) == ScheduleBehavior.Schedule.VIEW;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        super.m_6735_(level, (LivingEntity)maid, p_22542_);
        AdvancementTypes.triggerForMaid(maid, "storage_manager");
        if (!this.priorityTarget(level, maid)) {
            this.searchForDestination(level, maid);
        }
        if (!maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get())) {
            if (MemoryUtil.getViewedInventory(maid).confirmNoTarget(2)) {
                MemoryUtil.getViewedInventory(maid).removeUnvisited();
                MemoryUtil.getViewedInventory(maid).resetVisitedPos();
                DebugData.sendDebug("[VIEW]Reset, waiting", new Object[0]);
            }
        } else {
            MemoryUtil.getViewedInventory(maid).resetFailCount();
            if (this.chestPos != null) {
                MemoryUtil.getViewedInventory(maid).setTarget(this.chestPos);
                maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.chestPos.getPos()));
            }
        }
    }

    private boolean priorityTarget(ServerLevel level, EntityMaid maid) {
        Target toCheckTarget = MemoryUtil.getViewedInventory(maid).getMarkChanged().peek();
        if (toCheckTarget != null) {
            BlockPos target;
            @Nullable Target storage = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, toCheckTarget.getPos(), toCheckTarget.side);
            if (storage != null && StoragePredictor.isViewable(storage) && (target = MoveUtil.selectPosForTarget(level, maid, toCheckTarget.getPos())) != null) {
                this.chestPos = storage;
                MemoryUtil.setTarget(maid, target, (float)Config.viewChangeSpeed);
                DebugData.sendDebug("[VIEW]Priority By Change %s", storage);
                MemoryUtil.getViewedInventory(maid).resetMarkFailTime();
                return true;
            }
            MemoryUtil.getViewedInventory(maid).markFailTime();
            return true;
        }
        return false;
    }

    protected boolean shouldMoveTo(@NotNull ServerLevel serverLevel, EntityMaid entityMaid, @NotNull BlockPos blockPos) {
        if (!PosUtil.isSafePos((Level)serverLevel, blockPos)) {
            return false;
        }
        Target canTouchChest = MoveUtil.findTargetForPos(serverLevel, entityMaid, blockPos, MemoryUtil.getViewedInventory(entityMaid), false, StoragePredictor::isViewable);
        if (canTouchChest != null) {
            DebugData.sendDebug("[VIEW]Target %s", canTouchChest);
            this.chestPos = canTouchChest;
            return true;
        }
        return false;
    }
}

