/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.logistics.recycle;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.items.LogisticsGuide;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.LogisticsMemory;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;

public class LogisticsRecycleMoveBehavior
extends Behavior<EntityMaid> {
    public LogisticsRecycleMoveBehavior() {
        super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT, (MemoryModuleType)InitEntities.TARGET_POS.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        return MemoryUtil.getLogistics(maid).shouldWork() && MemoryUtil.getLogistics(maid).getStage() == LogisticsMemory.Stage.RECYCLE;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        BlockPos goal;
        Target storage;
        List<ItemStack> items = MemoryUtil.getLogistics(maid).getCraftLayer().getItems();
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        boolean found = false;
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            int finalI = i;
            if (availableInv.getStackInSlot(i).m_41619_() || !items.stream().anyMatch(ii -> ItemStackUtil.isSame(ii, availableInv.getStackInSlot(finalI), false))) continue;
            found = true;
        }
        if (!found) {
            MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.FINISH);
            return;
        }
        @Nullable Target target = LogisticsGuide.getInput(MemoryUtil.getLogistics(maid).getCurrentLogisticsGuideItem());
        Target target2 = storage = target == null ? null : MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, target.getPos(), target.side);
        if (target != null && storage != null && (goal = MoveUtil.selectPosForTarget(level, maid, target.pos)) != null) {
            MemoryUtil.getLogistics(maid).setTarget(storage);
            MemoryUtil.getLogistics(maid).resetFailCount();
            MemoryUtil.setTarget(maid, goal, (float)Config.collectSpeed);
            return;
        }
        MemoryUtil.getLogistics(maid).addFailCount();
        if (MemoryUtil.getLogistics(maid).getFailCount() > 10) {
            MemoryUtil.getLogistics(maid).resetFailCount();
            MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.FINISH);
        }
    }
}

