/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.special;

import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.CraftingSubmitErrorCode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.me.helpers.PlayerSource;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Future;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.ae2.Ae2BaseContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.util.WrappedMaidFakePlayer;

public class AeCraftingAction
extends CommonTakeItemAction {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "ae2_craft");
    int nextCrafting = 0;
    Future<ICraftingPlan> currentCalculating = null;
    Queue<ICraftingLink> craftingLinks = new LinkedList<ICraftingLink>();
    int toTick = 0;

    public AeCraftingAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        return super.start();
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        AbstractCraftActionContext.Result result = super.tick();
        if (result == AbstractCraftActionContext.Result.SUCCESS) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        IStorageContext iStorageContext = this.storageContext;
        if (iStorageContext instanceof Ae2BaseContext) {
            Ae2BaseContext ae2BaseContext = (Ae2BaseContext)iStorageContext;
            if (this.nextCrafting >= this.craftGuideStepData.getOutput().size()) {
                if (this.maid.m_9236_().m_7654_().m_129921_() > this.toTick) {
                    return AbstractCraftActionContext.Result.NOT_DONE;
                }
                return AbstractCraftActionContext.Result.CONTINUE;
            }
            ICraftingService craftingService = ae2BaseContext.getCraftingService();
            if (this.currentCalculating == null) {
                if (craftingService.getCpus().stream().allMatch(ICraftingCPU::isBusy)) {
                    return AbstractCraftActionContext.Result.CONTINUE;
                }
                ItemStack itemStack = this.craftGuideStepData.getOutput().get(this.nextCrafting);
                this.currentCalculating = craftingService.beginCraftingCalculation(this.maid.m_9236_(), () -> new PlayerSource((Player)WrappedMaidFakePlayer.get(this.maid), (IActionHost)ae2BaseContext.getPart()), (AEKey)AEItemKey.of((ItemStack)itemStack), (long)itemStack.m_41613_(), CalculationStrategy.CRAFT_LESS);
            } else if (this.currentCalculating.isDone()) {
                try {
                    ICraftingSubmitResult iCraftingSubmitResult;
                    ICraftingPlan plan = this.currentCalculating.get();
                    if (plan != null && plan.missingItems().isEmpty() && !(iCraftingSubmitResult = craftingService.submitJob(plan, null, null, true, (IActionSource)new PlayerSource((Player)WrappedMaidFakePlayer.get(this.maid), (IActionHost)ae2BaseContext.getPart()))).successful()) {
                        if (iCraftingSubmitResult.errorCode() == CraftingSubmitErrorCode.CPU_BUSY) {
                            return AbstractCraftActionContext.Result.CONTINUE;
                        }
                        return AbstractCraftActionContext.Result.FAIL;
                    }
                    this.currentCalculating = null;
                    ++this.nextCrafting;
                    this.toTick = this.maid.m_9236_().m_7654_().m_129921_() + 2400;
                }
                catch (Exception ignored) {
                    return AbstractCraftActionContext.Result.FAIL;
                }
                return AbstractCraftActionContext.Result.CONTINUE;
            }
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }
}

