/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.ItemStackUtil;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FuelCookRule<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final FuelCookRule INSTANCE = new FuelCookRule();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> FuelCookRule<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        boolean cookStateMatch = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasActiveItem = cookBeBase.hasActiveItem();
        boolean hasInputs = cookBeBase.hasInputs();
        boolean findFuel = false;
        if (!recMatch && !hasInputs && cm.hasMaidRecs(cookBeBase)) {
            if (!cookStateMatch) {
                List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.hasItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
                if (findFuel) {
                    return true;
                }
            } else {
                return true;
            }
            return true;
        }
        if (recMatch && !cookStateMatch && !hasActiveItem) {
            if (!findFuel) {
                List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.hasItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
            }
            if (findFuel) {
                return true;
            }
        }
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            return true;
        }
        return hasActiveItem && cookStateMatch && !recMatch && hasInputAvailableSlot;
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        List<ItemStack> activeItemStacks;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_() && hasOutputAvailableSlot) {
            cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
        }
        boolean cookStateMatch = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        ItemStack activeItemStack = cookBeBase.activeItemStack();
        boolean hasInputs = cookBeBase.hasInputs();
        ItemStack findFuel = ItemStack.f_41583_;
        if (!recMatch && !hasInputs && cm.hasMaidRecs(cookBeBase)) {
            if (!cookStateMatch) {
                activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.getItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
                if (!findFuel.m_41619_()) {
                    ItemInventory itemInventory = cm.getItemInventory();
                    cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
                    cookBeBase.markChanged();
                    recMatch = true;
                }
            } else {
                ItemInventory itemInventory = cm.getItemInventory();
                cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
                cookBeBase.markChanged();
                recMatch = true;
            }
        }
        if (recMatch && !cookStateMatch && activeItemStack.m_41619_()) {
            if (findFuel.m_41619_()) {
                activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.getItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
            }
            if (!findFuel.m_41619_()) {
                cookBeBase.insertItem(findFuel, cookBeBase.activeItemInv(), cookBeBase.activeItemSlot());
                cookBeBase.markChanged();
            }
        }
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
        if (!activeItemStack.m_41619_() && !recMatch && hasInputAvailableSlot) {
            cookBeBase.takeItem(activeItemStack, (IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
    }
}

