/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.util;

import com.github.wallev.farmsoulkitchen.FarmsoulKitchen;
import com.github.wallev.farmsoulkitchen.util.EntityUtil;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public final class FakePlayerUtil {
    private static final UUID ID = UUID.randomUUID();

    public static boolean isFakePlayer(Entity attacker) {
        return attacker instanceof FakePlayer;
    }

    public static WeakReference<FakePlayer> initFakePlayer(ServerLevel ws, String blockName) {
        String name = "fake_player." + blockName;
        GameProfile breakerProfile = new GameProfile(ID, name);
        WeakReference<FakePlayer> fakePlayer = new WeakReference<FakePlayer>(FakePlayerFactory.get((ServerLevel)ws, (GameProfile)breakerProfile));
        if (fakePlayer == null || fakePlayer.get() == null) {
            fakePlayer = null;
            return null;
        }
        ((FakePlayer)fakePlayer.get()).m_6853_(true);
        ((FakePlayer)fakePlayer.get()).f_8906_ = new ServerGamePacketListenerImpl(ws.m_7654_(), new Connection(PacketFlow.SERVERBOUND), (ServerPlayer)fakePlayer.get()){

            public void m_9829_(Packet<?> packetIn) {
            }
        };
        ((FakePlayer)fakePlayer.get()).m_20225_(true);
        return fakePlayer;
    }

    public static WeakReference<FakePlayer> setupBeforeTrigger(ServerLevel sw, String name, Entity entity) {
        WeakReference<FakePlayer> fakePlayer = FakePlayerUtil.initFakePlayer(sw, name);
        if (fakePlayer == null) {
            FarmsoulKitchen.LOGGER.error("Fake player failed to init " + name);
            return null;
        }
        ((FakePlayer)fakePlayer.get()).m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        ((FakePlayer)fakePlayer.get()).m_146922_(EntityUtil.getYawFromFacing(Direction.UP));
        return fakePlayer;
    }

    public static InteractionResult interactUseOnBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos, InteractionHand hand, Direction facing) {
        if (fakePlayer == null) {
            return InteractionResult.FAIL;
        }
        Direction placementOn = facing == null ? ((FakePlayer)fakePlayer.get()).m_6374_() : facing;
        BlockHitResult blockraytraceresult = new BlockHitResult(((FakePlayer)fakePlayer.get()).m_20154_(), placementOn, targetPos, true);
        ItemStack itemInHand = ((FakePlayer)fakePlayer.get()).m_21120_(hand);
        InteractionResult result = ((FakePlayer)fakePlayer.get()).f_8941_.m_7179_((ServerPlayer)fakePlayer.get(), world, itemInHand, hand, blockraytraceresult);
        return result;
    }

    public static InteractionResult interactUseOnBlockByDiscrete(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos, ItemStack itemStack, Direction facing) {
        if (fakePlayer == null) {
            return InteractionResult.FAIL;
        }
        FakePlayer fakePlayer1 = (FakePlayer)fakePlayer.get();
        Direction placementOn = facing == null ? fakePlayer1.m_6374_() : facing;
        BlockHitResult blockraytraceresult = new BlockHitResult(fakePlayer1.m_20154_(), placementOn, targetPos, true);
        fakePlayer1.m_21008_(InteractionHand.MAIN_HAND, itemStack);
        fakePlayer1.m_20260_(true);
        fakePlayer1.m_20124_(Pose.CROUCHING);
        InteractionResult result = fakePlayer1.f_8941_.m_7179_((ServerPlayer)fakePlayer1, world, itemStack, InteractionHand.MAIN_HAND, blockraytraceresult);
        fakePlayer1.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        fakePlayer1.m_20260_(false);
        return result;
    }
}

