/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class MaidFeedAnimalTaskT
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private final int maxAnimalCount;
    private Animal feedEntity = null;

    public MaidFeedAnimalTaskT(float speedModifier, int maxAnimalCount) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.maxAnimalCount = maxAnimalCount;
        this.setMaxCheckRate(12);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.feedEntity = null;
        List<LivingEntity> list = this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(livingEntity -> livingEntity instanceof Animal).filter(Entity::m_6084_).toList();
        HashMap<EntityType, List> resourceLocationListHashMap = new HashMap<EntityType, List>();
        for (LivingEntity livingEntity2 : list) {
            resourceLocationListHashMap.computeIfAbsent(livingEntity2.m_6095_(), k -> Lists.newArrayList()).add((Animal)livingEntity2);
        }
        for (List animals : resourceLocationListHashMap.values()) {
            if (animals.size() < this.maxAnimalCount - 2) {
                animals.stream().filter(e -> maid.m_21444_(e.m_20183_())).filter(e -> e.m_146764_() == 0).filter(e -> e.m_5957_()).filter(e -> ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)e).m_6898_(arg_0))).filter(arg_0 -> ((EntityMaid)maid).canPathReach(arg_0)).findFirst().ifPresent(e -> {
                    this.feedEntity = e;
                    BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
                });
                if (this.feedEntity != null && this.feedEntity.m_19950_((Entity)maid, 2.0)) {
                    ItemStack food = ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)this.feedEntity).m_6898_(arg_0));
                    if (!food.m_41619_()) {
                        food.m_41774_(1);
                        maid.m_6674_(InteractionHand.MAIN_HAND);
                        this.feedEntity.m_27595_(null);
                        return;
                    }
                    this.feedEntity = null;
                    Animal animal = (Animal)animals.get(0);
                    EntityType type = animal.m_6095_();
                    ChatBubbleManger.addInnerChatText((EntityMaid)maid, (String)String.format("chat_bubble.farmsoulkitchen.inner.feed_animal.type.none_food.%d", maid.m_217043_().m_188503_(3)));
                }
            }
            Animal animal = (Animal)animals.get(0);
            EntityType type = animal.m_6095_();
            ChatBubbleManger.addInnerChatText((EntityMaid)maid, (String)String.format("chat_bubble.farmsoulkitchen.inner.feed_animal.type.max_number.%d", maid.m_217043_().m_188503_(3)));
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }
}

