/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.compat.builder.task.ab;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.wallev.farmsoulkitchen.compat.builder.task.ab.CustomTaskABBaseBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class CustomTaskABBase<T extends CustomTaskABBaseBuilder>
implements ILittleMaid,
IMaidTask {
    public final ResourceLocation id;
    protected ResourceLocation uid;
    protected ItemStack icon;
    protected BiFunction<IMaidTask, EntityMaid, SoundEvent> getAmbientSound;
    protected BiFunction<IMaidTask, EntityMaid, List<Pair<Double, BehaviorControl<? super EntityMaid>>>> createBrainTasks;
    protected BiFunction<IMaidTask, EntityMaid, Boolean> isEnable;
    protected MutableComponent name;
    protected BiFunction<IMaidTask, EntityMaid, List<Pair<String, Predicate<EntityMaid>>>> getConditionDescription;
    protected BiFunction<IMaidTask, EntityMaid, List<String>> getDescription;

    public CustomTaskABBase(T t) {
        this.id = ((CustomTaskABBaseBuilder)t).id;
        this.initBuilderData(t);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return this.getAmbientSound.apply(this, maid);
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        List<Pair<Double, BehaviorControl<? super EntityMaid>>> apply = this.createBrainTasks.apply(this, maid);
        TouhouLittleMaid.LOGGER.info("CustomTaskBase:  createBrainTasks = " + apply);
        ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>> pairList1 = new ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>>();
        for (Pair<Double, BehaviorControl<? super EntityMaid>> pair1 : apply) {
            pairList1.add((Pair<Integer, BehaviorControl<? super EntityMaid>>)Pair.of((Object)((Double)pair1.getFirst()).intValue(), (Object)((BehaviorControl)pair1.getSecond())));
        }
        TouhouLittleMaid.LOGGER.info("CustomTaskBase:  createBrainTasks  TRANS = " + pairList1);
        return pairList1;
    }

    public boolean isEnable(EntityMaid maid) {
        TouhouLittleMaid.LOGGER.info("CustomTaskBase:  isEnable = " + this.isEnable);
        if (this.isEnable != null) {
            return this.isEnable.apply(this, maid);
        }
        return super.isEnable(maid);
    }

    public MutableComponent getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        if (this.getConditionDescription != null) {
            return this.getConditionDescription.apply(this, maid);
        }
        return super.getConditionDescription(maid);
    }

    public List<String> getDescription(EntityMaid maid) {
        if (this.getDescription != null) {
            return this.getDescription.apply(this, maid);
        }
        return super.getDescription(maid);
    }

    public void addMaidTask(TaskManager manager) {
        manager.add((IMaidTask)this);
    }

    public void initBuilderData(T t) {
        ((CustomTaskABBaseBuilder)t).acceptThis.accept(this);
        this.uid = ((CustomTaskABBaseBuilder)t).uid;
        this.icon = ((CustomTaskABBaseBuilder)t).icon;
        this.getAmbientSound = ((CustomTaskABBaseBuilder)t).getAmbientSound;
        this.createBrainTasks = ((CustomTaskABBaseBuilder)t).createBrainTasks;
        this.isEnable = ((CustomTaskABBaseBuilder)t).isEnable;
        this.name = ((CustomTaskABBaseBuilder)t).name;
        this.getConditionDescription = ((CustomTaskABBaseBuilder)t).getConditionDescription;
        this.getDescription = ((CustomTaskABBaseBuilder)t).getDescription;
    }
}

