/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.compat.builder.ai.ab;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.compat.builder.ai.ab.CustomABBehaviorBuilder;
import com.github.wallev.farmsoulkitchen.compat.builder.ai.ab.IAcceptThis;
import com.github.wallev.farmsoulkitchen.util.function.Consumer3;
import com.github.wallev.farmsoulkitchen.util.function.Predicate3;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public abstract class CustomABBehavior<T extends CustomABBehaviorBuilder>
extends Behavior<EntityMaid>
implements IAcceptThis {
    protected Supplier<Behavior.Status> getStatus;
    protected Consumer3<ServerLevel, EntityMaid, Long> start;
    protected Consumer3<ServerLevel, EntityMaid, Long> tick;
    protected Consumer3<ServerLevel, EntityMaid, Long> stop;
    protected Predicate3<ServerLevel, EntityMaid, Long> canStillUse;
    protected Predicate<Long> timedOut;
    protected BiPredicate<ServerLevel, EntityMaid> checkExtraStartConditions;
    protected Predicate<EntityMaid> hasRequiredMemories;

    public CustomABBehavior(Map<MemoryModuleType<?>, MemoryStatus> pEntryCondition) {
        super(pEntryCondition);
    }

    public CustomABBehavior(Map<MemoryModuleType<?>, MemoryStatus> pEntryCondition, int pDuration) {
        super(pEntryCondition, pDuration);
    }

    public CustomABBehavior(Map<MemoryModuleType<?>, MemoryStatus> pEntryCondition, int pMinDuration, int pMaxDuration) {
        super(pEntryCondition, pMinDuration, pMaxDuration);
    }

    public Behavior.Status m_22536_() {
        return this.getStatus != null ? this.getStatus.get() : this.superGetStatus();
    }

    protected void start(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        if (this.start != null) {
            this.start.accept(pLevel, pEntity, pGameTime);
        } else {
            this.superStart(pLevel, pEntity, pGameTime);
        }
    }

    protected void tick(ServerLevel pLevel, EntityMaid pOwner, long pGameTime) {
        if (this.tick != null) {
            this.tick.accept(pLevel, pOwner, pGameTime);
        } else {
            this.superTick(pLevel, pOwner, pGameTime);
        }
    }

    protected void stop(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        if (this.stop != null) {
            this.stop.accept(pLevel, pEntity, pGameTime);
        } else {
            this.superStop(pLevel, pEntity, pGameTime);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        if (this.canStillUse != null) {
            return this.canStillUse.test(pLevel, pEntity, pGameTime);
        }
        return this.superCanStillUse(pLevel, pEntity, pGameTime);
    }

    protected boolean m_7773_(long pGameTime) {
        if (this.timedOut != null) {
            return this.timedOut.test(pGameTime);
        }
        return this.superTimedOut(pGameTime);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, EntityMaid pOwner) {
        if (this.checkExtraStartConditions != null) {
            return this.checkExtraStartConditions.test(pLevel, pOwner);
        }
        return this.superCheckExtraStartConditions(pLevel, pOwner);
    }

    protected boolean hasRequiredMemories(EntityMaid pOwner) {
        if (this.hasRequiredMemories != null) {
            return this.hasRequiredMemories.test(pOwner);
        }
        return this.superHasRequiredMemories(pOwner);
    }

    public void initBuilderData(T t) {
        ((CustomABBehaviorBuilder)t).acceptThis.accept(this);
        this.getStatus = ((CustomABBehaviorBuilder)t).getStatus;
        this.start = ((CustomABBehaviorBuilder)t).start;
        this.tick = ((CustomABBehaviorBuilder)t).tick;
        this.stop = ((CustomABBehaviorBuilder)t).stop;
        this.canStillUse = ((CustomABBehaviorBuilder)t).canStillUse;
        this.timedOut = ((CustomABBehaviorBuilder)t).timedOut;
        this.checkExtraStartConditions = ((CustomABBehaviorBuilder)t).checkExtraStartConditions;
        this.hasRequiredMemories = ((CustomABBehaviorBuilder)t).hasRequiredMemories;
    }

    public boolean superCheckExtraStartConditions(ServerLevel pLevel, EntityMaid pOwner) {
        return super.m_6114_(pLevel, (LivingEntity)pOwner);
    }

    public Behavior.Status superGetStatus() {
        return super.m_22536_();
    }

    public void superStart(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        super.m_6735_(pLevel, (LivingEntity)pEntity, pGameTime);
    }

    public void superTick(ServerLevel pLevel, EntityMaid pOwner, long pGameTime) {
        super.m_6725_(pLevel, (LivingEntity)pOwner, pGameTime);
    }

    public void superStop(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
    }

    public boolean superCanStillUse(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        return super.m_6737_(pLevel, (LivingEntity)pEntity, pGameTime);
    }

    public boolean superTimedOut(long pGameTime) {
        return super.m_7773_(pGameTime);
    }

    public boolean superHasRequiredMemories(EntityMaid pOwner) {
        return super.m_22543_((LivingEntity)pOwner);
    }
}

