/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.api.task.v2;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.task.v2.IBeInv;
import com.github.wallev.farmsoulkitchen.task.cook.handler.v2.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.action.IMaidAction;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.cbaccessor.IFdCbeAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public interface IBaseCook<B extends BlockEntity, R extends Recipe<? extends Container>>
extends IMaidAction {
    public int getOutputSlot();

    default public int getInputStartSlot() {
        return 0;
    }

    public int getInputSize();

    default public <T extends IBeInv<B>> boolean outputCanMoveTo(T inventoryHandler, EntityMaid maid, B be, MaidRecipesManager<R> maidRecManager) {
        return !this.getStackInBeSlot(be, this.getOutputSlot()).m_41619_();
    }

    default public <T extends IBeInv<B>> boolean outputCanMoveTo(EntityMaid maid, B be, MaidRecipesManager<R> maidRecManager) {
        return !this.getStackInBeSlot(be, this.getOutputSlot()).m_41619_();
    }

    default public <T extends IBeInv<B>> boolean beCookCanMoveTo(T inventoryHandler, EntityMaid maid, B be, MaidRecipesManager<R> maidRecManager) {
        return !this.beInnerCanCook(be, inventoryHandler) && !maidRecManager.getRecipesIngredients().isEmpty();
    }

    default public boolean beCookCanMoveTo(boolean innerBeCanCook, EntityMaid maid, B be, MaidRecipesManager<R> maidRecManager) {
        return !innerBeCanCook && !maidRecManager.getRecipesIngredients().isEmpty();
    }

    default public <T extends IBeInv<B>> boolean beInputCanMoveTo(T inventoryHandler, EntityMaid maid, B be, MaidRecipesManager<R> maidRecManager) {
        return this.hasInput(be) && !this.beInnerCanCook(be, inventoryHandler);
    }

    default public boolean beInputCanMoveTo(boolean innerBeCanCook, EntityMaid maid, B be, MaidRecipesManager<R> maidRecManager) {
        return this.hasInput(be) && !innerBeCanCook;
    }

    default public <T extends IBeInv<B>> boolean beInnerCanCook(B be, T inventoryHandler) {
        RecipeWrapper recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)inventoryHandler);
        Optional matchingRecipe = ((IFdCbeAccessor)be).getMatchingRecipe$tlma(recipeWrapper);
        return matchingRecipe.isPresent() && ((IFdCbeAccessor)be).canCook$tlma((Recipe)matchingRecipe.get());
    }

    default public <T extends IBeInv<B>> void extractOutputMake(T inventoryHandler, EntityMaid maid, CombinedInvWrapper availableInv, B be, MaidRecipesManager<R> maidRecManager) {
        if (this.outputCanMoveTo(inventoryHandler, maid, be, maidRecManager)) {
            this.extractOutputStack(availableInv, be);
        }
    }

    default public <T extends IBeInv<B>> void extractAndInsertInputMake(T inventoryHandler, EntityMaid maid, CombinedInvWrapper availableInv, B be, MaidRecipesManager<R> maidRecManager) {
        if (!this.beInputCanMoveTo(inventoryHandler, maid, be, maidRecManager)) {
            return;
        }
        this.extractInputsStack(availableInv, be);
        Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = maidRecManager.getRecipeIngredient();
        if (recipeIngredient == null) {
            return;
        }
        this.insertInputsStack(availableInv, be, recipeIngredient);
    }

    default public void extractOutputStack(CombinedInvWrapper availableInv, B be) {
        ItemStack stackInSlot = this.getStackInBeSlot(be, this.getOutputSlot());
        if (stackInSlot.m_41619_()) {
            return;
        }
        this.extractAndInsertAction(be, availableInv, stackInSlot.m_41777_(), this.getOutputSlot());
        be.m_6596_();
    }

    default public void extractInputsStack(CombinedInvWrapper availableInv, B be) {
        for (int i = this.getInputStartSlot(); i < this.getInputSize() + this.getInputStartSlot(); ++i) {
            ItemStack stackInSlot = this.getStackInBeSlot(be, i);
            if (stackInSlot.m_41619_()) continue;
            this.extractAndInsertAction(be, availableInv, stackInSlot.m_41777_(), i);
        }
        be.m_6596_();
    }

    default public void insertInputsStack(CombinedInvWrapper availableInv, B be, Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
        List ingredients;
        List amounts = (List)ingredientPair.getFirst();
        if (this.hasEnoughIngredient(amounts, ingredients = (List)ingredientPair.getSecond())) {
            int i = this.getInputStartSlot();
            int j = 0;
            while (i < ingredients.size() + this.getInputStartSlot()) {
                this.insertAndShrink(be, amounts, ingredients, j, i);
                ++i;
                ++j;
            }
            be.m_6596_();
        }
        this.updateIngredient(ingredientPair);
    }

    default public void updateIngredients(List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients) {
    }

    default public void updateIngredient(Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
    }

    default public boolean hasEnoughIngredient(List<Integer> amounts, List<List<ItemStack>> ingredients) {
        boolean canInsert = true;
        int i = 0;
        for (List<ItemStack> ingredient : ingredients) {
            int actualCount = amounts.get(i++);
            for (ItemStack itemStack : ingredient) {
                if ((actualCount -= itemStack.m_41613_()) <= 0) break;
            }
            if (actualCount <= 0) continue;
            canInsert = false;
            break;
        }
        return canInsert;
    }

    default public void insertAndShrink(B be, List<Integer> amounts, List<List<ItemStack>> ingredient, int ingredientIndex, int slotIndex) {
        int i = 0;
        for (ItemStack itemStack : ingredient.get(ingredientIndex)) {
            int shinkNum = amounts.get(i++);
            int count = itemStack.m_41613_();
            if (count >= shinkNum) {
                this.insertStack2BeAction(be, itemStack.m_255036_(shinkNum), slotIndex);
                itemStack.m_41774_(shinkNum);
                break;
            }
            this.insertStack2BeAction(be, itemStack.m_255036_(count), slotIndex);
            itemStack.m_41774_(count);
            if ((shinkNum -= count) > 0) continue;
            break;
        }
    }

    default public boolean hasInput(B be) {
        for (int i = this.getInputStartSlot(); i < this.getInputSize() + this.getInputStartSlot(); ++i) {
            if (this.getStackInBeSlot(be, i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    default public void insertStack2MaidAction(CombinedInvWrapper availableInv, ItemStack insertStack) {
        ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)insertStack, (boolean)false);
    }

    public ItemStack getStackInBeSlot(B var1, int var2);

    default public void extractAndInsertAction(B be, CombinedInvWrapper availableInv, ItemStack insertStack, int extractSlot) {
        this.extractStack2BeAction(be, extractSlot, insertStack.m_41613_());
        this.insertStack2MaidAction(availableInv, insertStack);
    }

    public void extractStack2BeAction(B var1, int var2, int var3);

    public void insertStack2BeAction(B var1, ItemStack var2, int var3);
}

