/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.api.task.v1.cook;

import com.github.wallev.farmsoulkitchen.task.cook.v1.common.action.IMaidAction;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public interface IItemHandlerCook
extends IMaidAction {
    public int getOutputSlot();

    default public int getInputStartSlot() {
        return 0;
    }

    public int getInputSize();

    default public void extractOutputStack(ItemStackHandler beInv, IItemHandlerModifiable availableInv, BlockEntity blockEntity) {
        ItemStack stackInSlot = beInv.getStackInSlot(this.getOutputSlot());
        ItemStack copy = stackInSlot.m_41777_();
        if (stackInSlot.m_41619_()) {
            return;
        }
        beInv.extractItem(this.getOutputSlot(), stackInSlot.m_41613_(), false);
        ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)copy, (boolean)false);
        blockEntity.m_6596_();
    }

    default public void extractInputStack(ItemStackHandler beInv, IItemHandlerModifiable availableInv, BlockEntity blockEntity) {
        for (int i = this.getInputStartSlot(); i < this.getInputSize() + this.getInputStartSlot(); ++i) {
            ItemStack stackInSlot = beInv.getStackInSlot(i);
            ItemStack copy = stackInSlot.m_41777_();
            if (stackInSlot.m_41619_()) continue;
            beInv.extractItem(i, stackInSlot.m_41613_(), false);
            ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)copy, (boolean)false);
        }
        blockEntity.m_6596_();
    }

    default public void insertInputStack(ItemStackHandler beInv, IItemHandlerModifiable availableInv, BlockEntity blockEntity, Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
        List ingredients;
        List amounts = (List)ingredientPair.getFirst();
        if (this.hasEnoughIngredient(amounts, ingredients = (List)ingredientPair.getSecond())) {
            int i = this.getInputStartSlot();
            int j = 0;
            while (i < ingredients.size() + this.getInputStartSlot()) {
                this.insertAndShrink(beInv, (Integer)amounts.get(j), ingredients, j, i);
                ++i;
                ++j;
            }
            blockEntity.m_6596_();
        }
        this.updateIngredient(ingredientPair);
    }

    default public void updateIngredients(List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients) {
    }

    default public void updateIngredient(Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
    }

    default public boolean hasEnoughIngredient(List<Integer> amounts, List<List<ItemStack>> ingredients) {
        boolean canInsert = true;
        int i = 0;
        for (List<ItemStack> ingredient : ingredients) {
            int actualCount = amounts.get(i++);
            for (ItemStack itemStack : ingredient) {
                if ((actualCount -= itemStack.m_41613_()) <= 0) break;
            }
            if (actualCount <= 0) continue;
            canInsert = false;
            break;
        }
        return canInsert;
    }

    default public void insertAndShrink(ItemStackHandler inventory, Integer amount, List<List<ItemStack>> ingredient, int ingredientIndex, int slotIndex) {
        for (ItemStack itemStack : ingredient.get(ingredientIndex)) {
            if (itemStack.m_41619_()) continue;
            int count = itemStack.m_41613_();
            if (count >= amount) {
                inventory.insertItem(slotIndex, itemStack.m_255036_(amount.intValue()), false);
                itemStack.m_41774_(amount.intValue());
                break;
            }
            inventory.insertItem(slotIndex, itemStack.m_255036_(count), false);
            itemStack.m_41774_(count);
            if ((amount = Integer.valueOf(amount - count)) > 0) continue;
            break;
        }
    }

    default public boolean hasInput(ItemStackHandler inventory) {
        for (int i = this.getInputStartSlot(); i < this.getInputSize() + this.getInputStartSlot(); ++i) {
            if (inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }
}

