/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.other.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.debug.annotation.SafeRun;
import com.github.wallev.maidsoulkitchen.debug.annotation.TimeRecord;
import com.github.wallev.maidsoulkitchen.util.TextContactUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;

public class MaidFeedAnimalTaskT
extends MaidCheckRateTask
implements VBehaviorControl {
    private static final int MAX_DELAY_TIME = 400;
    private final float speedModifier;
    private final int maxAnimalCount;
    private Animal feedEntity = null;
    private EntityType<?> lastFeedType = null;
    private long lastFeedTime;

    public MaidFeedAnimalTaskT(float speedModifier, int maxAnimalCount) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148204_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.maxAnimalCount = maxAnimalCount;
        this.setMaxCheckRate(400);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return this.feedEntity != null || super.checkExtraStartConditions(worldIn, owner);
    }

    @TimeRecord
    @SafeRun
    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        if (this.feedEntity != null) {
            if (this.feedEntity.m_6084_() && this.feedEntity.m_19950_((Entity)maid, 2.0)) {
                ItemStack food = ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)this.feedEntity).m_6898_(arg_0));
                if (!food.m_41619_()) {
                    food.m_41774_(1);
                    maid.m_6674_(InteractionHand.MAIN_HAND);
                    this.feedEntity.m_27595_(null);
                    long gameTime = maid.f_19853_.m_46467_();
                    EntityType feedEntityType = this.feedEntity.m_6095_();
                    if (this.lastFeedType != null && this.lastFeedType != feedEntityType) {
                        maid.getChatBubbleManager().addChatBubble((IChatBubbleData)TextChatBubbleData.type2((Component)VComponent.translatable("chat_bubble.maidsoulkitchen.inner.feed_animal.feed_end")));
                    } else if (this.lastFeedType == feedEntityType && (gameTime - this.lastFeedTime) / 1000L >= 305L) {
                        maid.getChatBubbleManager().addChatBubble((IChatBubbleData)TextChatBubbleData.type2((Component)VComponent.translatable("chat_bubble.maidsoulkitchen.inner.feed_animal.feed_end")));
                    }
                    this.lastFeedTime = gameTime;
                    this.lastFeedType = feedEntityType;
                }
            }
            this.feedEntity = null;
        }
        maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(maid.m_21534_()));
        List<List> typeAnimals = this.getEntities(maid).stream().filter(e -> maid.m_21444_(e.m_20183_())).filter(e -> {
            if (!(e instanceof Animal)) return false;
            Animal animal = (Animal)e;
            if (!e.m_6084_()) return false;
            return true;
        }).map(Animal.class::cast).collect(() -> new LinkedHashMap(), (map, b) -> {
            EntityType entityType = b.m_6095_();
            List animals = map.computeIfAbsent(entityType, type -> new ArrayList());
            animals.add(b);
        }, (a, b) -> {}).values().stream().filter(o1 -> o1.size() > 2).sorted((o1, o2) -> o1.size() - o2.size()).sorted((o1, o2) -> {
            Animal animal0 = (Animal)o1.get(0);
            Animal animal1 = (Animal)o2.get(0);
            Vec3 position0 = animal0.f_19825_;
            Vec3 position1 = animal1.f_19825_;
            Vec3 maidPosition = maid.f_19825_;
            return (int)(maidPosition.m_82557_(position0) - maidPosition.m_82557_(position1));
        }).toList();
        if (typeAnimals.isEmpty()) {
            maid.getChatBubbleManager().addChatBubble((IChatBubbleData)TextChatBubbleData.type2((Component)VComponent.translatable("chat_bubble.maidsoulkitchen.inner.feed_animal.no_animals")));
        }
        ArrayList noneFoodAnimalTypes = new ArrayList();
        ArrayList maxAnimalTypes = new ArrayList();
        for (List animals : typeAnimals) {
            EntityType animalType = ((Animal)animals.get(0)).m_6095_();
            if (animals.size() < this.maxAnimalCount - 2) {
                Animal animal0 = (Animal)animals.get(0);
                boolean hasFood = ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(true), arg_0 -> ((Animal)animal0).m_6898_(arg_0));
                if (!hasFood) {
                    noneFoodAnimalTypes.add(animalType);
                    continue;
                }
                animals.stream().filter(e -> maid.m_21444_(e.m_20183_())).filter(e -> e.m_146764_() == 0).filter(e -> e.m_5957_()).filter(arg_0 -> ((EntityMaid)maid).canPathReach(arg_0)).findFirst().ifPresent(e -> {
                    this.feedEntity = e;
                    BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
                });
                if (this.feedEntity == null) continue;
                return;
            }
            maxAnimalTypes.add(animalType);
        }
        this.addFeedChatBubbleIfNeed(noneFoodAnimalTypes, maid, "none_food");
        this.addFeedChatBubbleIfNeed(maxAnimalTypes, maid, "max_number");
    }

    private void addFeedChatBubbleIfNeed(List<EntityType<?>> maxAnimalTypes, EntityMaid maid, String typeKey) {
        if (maxAnimalTypes.isEmpty()) {
            return;
        }
        MutableComponent typeComponent = TextContactUtil.contact(maxAnimalTypes, EntityType::m_20676_);
        MutableComponent maxAnimalComponent = VComponent.translatable(String.format("chat_bubble.maidsoulkitchen.inner.feed_animal.type." + typeKey + ".%d", maid.m_217043_().m_188503_(3)), typeComponent);
        maid.getChatBubbleManager().addChatBubble((IChatBubbleData)TextChatBubbleData.type2((Component)maxAnimalComponent));
    }

    private List<LivingEntity> getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148204_).orElse(Collections.emptyList());
    }
}

