/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.manager;

import com.github.wallev.maidsoulkitchen.config.subconfig.RegisterConfig;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ITaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.util.EnumCodecUtil;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskModClazzManager;
import com.github.wallev.maidsoulkitchen.util.DevUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TaskInfo implements ITaskInfo<Mods>
{
    NONE("", Mods.MC),
    IDLE("idle", Mods.MC),
    COOK("cook", Mods.MC, () -> RegisterConfig.COMPAT_MELON_FARM_TASK_ENABLED),
    COMPAT_MELON_FARM("compat_melon", Mods.MC, () -> RegisterConfig.COMPAT_MELON_FARM_TASK_ENABLED),
    BERRY_FARM("berries_farm", Mods.MC, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    FRUIT_FARM("fruit_farm", Mods.MC, () -> RegisterConfig.FRUIT_FARM_TASK_ENABLED),
    FEED_ANIMAL_T("feed_animal_t", Mods.MC, () -> RegisterConfig.FEED_ANIMAL_T_TASK_ENABLED),
    SERENESEASONS_FARM("sereneseasons_farm", Mods.SS, () -> RegisterConfig.SERENESEASONS_FARM_TASK_ENABLED),
    ECLIPTICSSEASONS_FARM("eclipticseasons_farm", Mods.ES, () -> RegisterConfig.ECLIPTICSEASONS_FARM_TASK_ENABLED),
    FURNACE("furnace", "furnace", "smelting", Mods.MC, true, () -> RegisterConfig.FURNACE_TASK_ENABLED),
    KC_POT("kc_pot", "pot", "pot", Mods.KC, true, () -> DevUtil.isDevEnv()),
    KC_CHOPPING_BOARD("kc_chopping_board", "chopping_board", "chopping_board", Mods.KC, true, () -> DevUtil.isDevEnv()),
    FD_COOK_POT("fd_cooking_pot", "cooking_pot", "cooking", Mods.FD, true, () -> RegisterConfig.FD_COOK_POT_TASK_ENABLED),
    FD_CUTTING_BOARD("fd_cutting_board", "cutting_board", "cutting", Mods.FD, true, () -> false),
    CD_CUISINE_SKILLET("cd_cuisine_skillet", "cuisine_skillet", "cuisine", Mods.CD, true, () -> DevUtil.isDevEnv()),
    MD_COOK_POT("md_copper_pot", "copper_pot", "cooking", Mods.MD, true, () -> RegisterConfig.MD_COOK_POT_TASK_ENABLED),
    COPPER_POT("copper_pot", "copper_pot", "cooking", Mods.COPPER_POT, true, () -> DevUtil.isDevEnv()),
    MONSTER_POT("monster_pot", "monster_pot", "monster_cooking", Mods.DUNGEONS_DELIGHT, true, () -> DevUtil.isDevEnv()),
    BNC_KEY("bnc_key", "keg", "fermenting", Mods.BNCD, true, () -> RegisterConfig.BNC_KEY_TASK_ENABLED),
    FR_KETTLE("fr_kettle", "kettle", "brewing", Mods.FRD, true, () -> RegisterConfig.FR_KETTLE_TASK_ENABLED),
    BD_BASIN("bd_basin", "basin", "skewering", Mods.BD, true, () -> DevUtil.isDevEnv()),
    BD_GRILL("bd_grill", "grill", "grilling", Mods.BD, true, () -> DevUtil.isDevEnv()),
    YHC_MOKA("yhc_moka_pot", "moka_pot", "moka_pot", Mods.YHCD, true, () -> RegisterConfig.YHC_MOKA_TASK_ENABLED),
    YHC_TEA_KETTLE("yhc_tea_kettle", "kettle", "kettle", Mods.YHCD, true, () -> RegisterConfig.YHC_TEA_KETTLE_TASK_ENABLED),
    YHC_DRYING_RACK("yhc_drying_rack", "drying_rack", "drying_rack", Mods.YHCD, true, () -> RegisterConfig.YHC_DRYING_RACK_TASK_ENABLED),
    YHC_FERMENTATION_TANK("yhc_fermentation_tank", "fermentation_tank", "fermentation", Mods.YHCD_NEW, true, () -> RegisterConfig.YHC_FERMENTATION_TANK_TASK_ENABLED),
    KK_BREW_BARREL("kk_brew_barrel", "brewing_barrel", "brewing_barrel", Mods.KK_NEW, true, () -> RegisterConfig.KK_BREW_BARREL),
    KK_AIR_COMPRESSOR("kk_air_compressor", "air_compressor", "air_compressing", Mods.KK, true, () -> RegisterConfig.KK_AIR_COMPRESSOR),
    DB_BEER("drinkbeer_beerbarrel", "beer_barrel", "brewing", Mods.DB, true, () -> RegisterConfig.DB_BEER_TASK_ENABLED),
    CP_CROCK_POT("cp_crock_pot", "crock_pot", "crock_pot_cooking", Mods.CP, true, () -> RegisterConfig.CP_CROk_POT_TASK_ENABLED),
    DFC_STOVE("stove", Mods.DFC, true, () -> DevUtil.isDevEnv()),
    DFC_ROASTER("roaster", Mods.DFC, true, () -> DevUtil.isDevEnv()),
    DFC_COOKING_POT("cooking_pot", Mods.DFC, true, () -> DevUtil.isDevEnv()),
    DBK_COOKING_POT("cooking_pot", Mods.DBK, true, () -> DevUtil.isDevEnv()),
    DCL_COOKING_POT("cooking_pot", Mods.DCL, true, () -> DevUtil.isDevEnv()),
    DCL_COOKING_PAN("cooking_pan", Mods.DCL, true, () -> DevUtil.isDevEnv()),
    DBP_MINI_FRIDGE("mine_fridge", Mods.DBP, true, () -> DevUtil.isDevEnv()),
    DBP_PALM_BAR("palm_bar", Mods.DBP, true, () -> DevUtil.isDevEnv()),
    DM_CHEESE_FORM("cheese_form", Mods.DM, true, () -> DevUtil.isDevEnv()),
    BERRY_MINECRAFT("berry_minecraft", Mods.MC, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    BERRY_L2_HARVESTER("berry_l2_harvester", Mods.L2_HARVESTER, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    BERRY_FARMERS_RESPITE_GREEN_TEA("berry_farmersrespite_greentea", Mods.FRD, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    BERRY_FARMERS_RESPITE_YELLOW_TEA("berry_farmersrespite_yellowtea", Mods.FRD, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    BERRY_FARMERS_RESPITE_BLACK_TEA("berry_farmersrespite_blacktea", Mods.FRD, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    BERRY_SIMPLE_FARMING("berry_simple_farming", Mods.SF, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    BERRY_COMPAT("berry_compat", Mods.MC, () -> RegisterConfig.BERRY_FARM_TASK_ENABLED),
    FRUIT_SIMPLE_FARMING("fruit_simple_farming", Mods.SF, () -> RegisterConfig.FRUIT_FARM_TASK_ENABLED),
    FRUIT_COMPAT("fruit_compat", Mods.MC, () -> RegisterConfig.FRUIT_FARM_TASK_ENABLED),
    LAYER_BAKERY("layer_bakery", Mods.DBK, () -> DevUtil.isDevEnv()),
    LAYER_BEACHPARTY("layer_beachparty", Mods.DBP, () -> DevUtil.isDevEnv()),
    LAYER_BLOOMINGNATURE("layer_bloomingnature", Mods.DBN, () -> DevUtil.isDevEnv()),
    LAYER_BREWERY("layer_brewery", Mods.DBR, () -> DevUtil.isDevEnv()),
    LAYER_CANDLELIGHT("layer_candlelight", Mods.DCL, () -> DevUtil.isDevEnv()),
    LAYER_HERBALBREWS("layer_herbalbrews", Mods.DHB, () -> DevUtil.isDevEnv()),
    LAYER_MEADOW("layer_meadow", Mods.DM, () -> DevUtil.isDevEnv()),
    LAYER_VINERY("layer_vinery", Mods.DBR, () -> DevUtil.isDevEnv()),
    MSM_FD_HAND_SKILLET("msm_fd_hand_skillet", Mods.FD, true),
    MSM_FD_SKILLET("msm_fd_skillet", Mods.FD, true),
    MSM_FD_STOVE("msm_fd_stove", Mods.FD, true),
    MSM_FD_COOKING_POT("msm_fd_cooking_pot", Mods.FD, true),
    MSM_FD_CUTTING_BOARD("msm_fd_cutting_board", Mods.FD, true),
    MSM_MD_COOKING_POT("msm_md_cooking_pot", Mods.MD, true),
    MSM_DD_MONSTER_POT("msm_dd_monster_pot", Mods.DUNGEONS_DELIGHT, true),
    MSM_CPD_COPPER_POT("msm_cp_copper_pot", Mods.COPPER_POT, true),
    MSM_DB_MIXED_BEER("msm_db_mixed_beer", Mods.DB, true),
    MSM_DB_DRINKBEER_BEERBARREL("msm_db_drinkbeer_beerbarrel", Mods.DB, true),
    MSM_YHC_CUISINE("msm_yhc_cuinse", Mods.YHCD, true),
    MSM_YHC_BASIN("msm_yhc_basin", Mods.YHCD, true),
    MSM_YHC_FERMENT("msm_yhc_ferment", Mods.YHCD_NEW, true),
    MSM_YHC_DRYING_RACK("msm_yhc_drying_rack", Mods.YHCD, true),
    MSM_YHC_MOKA_POT("msm_yhc_moka_pot", Mods.YHCD, true),
    MSM_YHC_KETTLE("msm_yhc_kettle", Mods.YHCD, true),
    MSM_TA_BAMBOO_TRAY("msm_ta_bamboo_tray", Mods.TA, true),
    MSM_TA_BREWING("msm_ta_brewing", Mods.TA, true),
    MSM_TA_FOAM("msm_ta_foam", Mods.TA, true),
    MSM_TA_BOILING("msm_ta_boiling", Mods.TA, true),
    MSM_TA_KETTLE_WATER("msm_ta_kettle_water", Mods.TA, true),
    MSM_SINGLE_GETTER_WATER("msm_single_getter_water", Mods.MAID_STORAGE_MANAGER, true),
    MSM_MULTI_GETTER_WATER("msm_erea_getter_water", Mods.MAID_STORAGE_MANAGER, true),
    MSM_KK_PLATEC_CUTTING("msm_kc_plate_cutting", Mods.KK, true),
    MSM_KK_BREWING("msm_kk_brewing", Mods.KK, true),
    MSM_KK_AIR_COMPRESSOR("msm_kk_air_compressor", Mods.KK, true),
    MSM_IMD_ENCHANTAL_COOLER("msm_imd_enchantal_cooler", Mods.IMD, true),
    MSM_ITEM_USE("msm_item_use", Mods.MAID_STORAGE_MANAGER, true),
    MSM_VTD_FERMENTING_JAR("msm_vtd_fermenting_jar", Mods.VTD, true),
    MSM_CORE("msm_core", Mods.MAID_STORAGE_MANAGER, true),
    MSM_BAKERY_DRINK_CUP("msm_bakery_drink_cup", Mods.BAKERIES, true),
    MSM_BAKERIES_CAKE_ROLL("msm_bakeries_cake_roll", Mods.BAKERIES, true),
    MSM_DO_BEKERY_SMALL_COOKING_POT("msm_do_bakery_small_cooking_pot", Mods.DBK, true),
    MSM_BAKERIES_BLENDER("msm_bakeris_blender", Mods.BAKERIES, true),
    MSM_BAKERIES_OVEN("msm_bakeries_oven", Mods.BAKERIES, true),
    MSM_BAKERIES_DOUGH("msm_bakeries_dough", Mods.BAKERIES, true),
    MSM_BAKERIES_FERMENTATION_TANK("msm_bakeries_fermentation_tank", Mods.BAKERIES, true),
    MSM_DO_BEACH_PARTY_MINI_FRIDGE("msm_do_beach_party_mini_frige", Mods.DBP, true),
    MSM_BEARCH_PARTY_PALM_BAR("msm_do_beach_party_plam_bar", Mods.DBP, true),
    MSM_CANDLE_LINGHT_COOKING_POT("msm_candle_light_cooking_pot", Mods.DCL, true),
    MSM_CANDLE_LINGHT_ROAST("msm_candle_light_roast", Mods.DCL, true),
    MSM_FARM_AND_CHARM_COOKING_POT("msm_farm_and_charm_cooking_pot", Mods.DFC, true),
    MSM_FARM_AND_CHARM_CRAFTING_BOWL("msm_farm_and_charm_crafting_bowl", Mods.DFC, true),
    MSM_FARM_AND_CHARM_ROASTER("msm_farm_and_charm_roster", Mods.DFC, true),
    MSM_FARM_AND_CHARM_STOVE("msm_farm_and_charm_stove", Mods.DFC, true),
    MSM_KC_COOKER("msm_kc_cooker", Mods.KC, true),
    MSM_KC_STOCK_POT("msm_kc_stock_pot", Mods.KC, true),
    MSM_KC_CHOPPING_BOARD("msm_kc_cutting_board", Mods.KC, true),
    MSM_KK_SHAKER("msm_kk_shaker", Mods.KK, true),
    MSM_MEADOW_CHEESE_FORM("msm_meadow_cheese_form", Mods.DM, true),
    MSM_SIMPLE_FARMING_FERMENTER("msm_simple_farming_ferment", Mods.SF, true),
    MSM_VINERY_GRAPE_POT("msm_vinery_grape_pot", Mods.DV, true),
    PACK_LITMIT("pack_limit", Mods.TLM, () -> DevUtil.isDevEnv());

    public static final TaskInfo[] VALUES;
    public static final Codec<TaskInfo> CODEC;
    private String oldName = "";
    private final ResourceLocation uid;
    private final Mods bindMod;
    private final Supplier<Boolean> bindConfig;

    private TaskInfo(ResourceLocation uid, Mods bindMod, Supplier<ForgeConfigSpec.BooleanValue> bindConfig) {
        this.uid = uid;
        this.bindMod = bindMod;
        this.bindConfig = () -> (Boolean)((ForgeConfigSpec.BooleanValue)bindConfig.get()).get();
    }

    private TaskInfo(String oldName, String uid, Mods bindMod, boolean concatModId, Supplier<ForgeConfigSpec.BooleanValue> bindConfig) {
        this.oldName = VResourceLocation.createMod(oldName).toString();
        this.uid = TaskInfo.convertUid(oldName, uid, bindMod, concatModId);
        this.bindMod = bindMod;
        this.bindConfig = () -> (Boolean)((ForgeConfigSpec.BooleanValue)bindConfig.get()).get();
    }

    private TaskInfo(String oldName, String uid, Mods bindMod, boolean concatModId, Config bindConfig) {
        this.oldName = VResourceLocation.createMod(oldName).toString();
        this.uid = TaskInfo.convertUid(oldName, uid, bindMod, concatModId);
        this.bindMod = bindMod;
        this.bindConfig = () -> bindConfig.canLoad();
    }

    private TaskInfo(String oldName, String blockId, String recipeId, Mods bindMod, boolean concatModId, Supplier<ForgeConfigSpec.BooleanValue> bindConfig) {
        this.oldName = VResourceLocation.createMod(oldName).toString();
        this.uid = TaskInfo.convertUid(oldName, blockId + "_" + recipeId, bindMod, concatModId);
        this.bindMod = bindMod;
        this.bindConfig = () -> (Boolean)((ForgeConfigSpec.BooleanValue)bindConfig.get()).get();
    }

    private TaskInfo(String oldName, String blockId, String recipeId, Mods bindMod, boolean concatModId, Config bindConfig) {
        this.oldName = VResourceLocation.createMod(oldName).toString();
        this.uid = TaskInfo.convertUid(oldName, blockId + "_" + recipeId, bindMod, concatModId);
        this.bindMod = bindMod;
        this.bindConfig = () -> bindConfig.canLoad();
    }

    private TaskInfo(String uid, Mods bindMod, boolean concatModId, Supplier<ForgeConfigSpec.BooleanValue> bindConfig) {
        this("", uid, bindMod, concatModId, bindConfig);
    }

    private TaskInfo(String uid, Mods bindMod, Supplier<ForgeConfigSpec.BooleanValue> bindConfig) {
        this(uid, bindMod, false, bindConfig);
    }

    private TaskInfo(String uid, Mods bindMod, boolean concatModId, Config bindConfig) {
        this.uid = TaskInfo.convertUid(this.oldName, uid, bindMod, concatModId);
        this.bindMod = bindMod;
        this.bindConfig = () -> bindConfig.canLoad();
    }

    private TaskInfo(String uid, Mods bindMod, boolean concatModId) {
        this.uid = TaskInfo.convertUid(this.oldName, uid, bindMod, concatModId);
        this.bindMod = bindMod;
        this.bindConfig = () -> true;
    }

    private TaskInfo(String uid, Mods bindMod, Config bindConfig) {
        this(uid, bindMod, false, bindConfig);
    }

    private TaskInfo(String uid, Mods bindMod) {
        this(uid, bindMod, false);
    }

    public static void init() {
    }

    private static ResourceLocation convertUid(String oldName, String uid, Mods bindMod, boolean concatModId) {
        return concatModId ? VResourceLocation.createMod(bindMod.modId() + "_" + uid) : VResourceLocation.createMod(uid);
    }

    public static TaskInfo by(String key) {
        return TaskInfo.valueOf(key);
    }

    @Nullable
    public static TaskInfo by(ResourceLocation taskUid) {
        for (TaskInfo value : TaskInfo.values()) {
            if (!value.uid.equals((Object)taskUid)) continue;
            return value;
        }
        return null;
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    @Override
    public String getUidStr() {
        return this.uid.toString();
    }

    @Override
    public Mods getBindMod() {
        return this.bindMod;
    }

    public boolean modVersionLoaded() {
        return this.bindMod.versionLoad();
    }

    public boolean configEnabled() {
        return this.bindConfig.get();
    }

    @Override
    public final boolean canLoad() {
        return this.canLoadWithoutCheckClazz() && TaskModClazzManager.clazzLoad(this.uid.toString());
    }

    @Override
    public boolean canLoadWithoutCheckClazz() {
        return this.modVersionLoaded() && this.configEnabled();
    }

    @Deprecated
    public String getOldName() {
        return this.oldName;
    }

    @Override
    @NotNull
    public String getSerializedName() {
        return this.getUid().toString();
    }

    static {
        VALUES = TaskInfo.values();
        CODEC = EnumCodecUtil.fromEnum(() -> VALUES);
    }

    private static interface Config {
        public boolean canLoad();
    }
}

