/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.manager;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.CookDataV1;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.chest.ChestInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.chest.ChestInvsData;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.HubItemDown;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.IItemDown;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.MaidItemDown;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.RecDataUse;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.MaidCookBagInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.MaidInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.CheckRange;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.IndexRange;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.RecsGenerate;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.util.BubbleUtil;
import com.github.wallev.maidsoulkitchen.util.InvUtil;
import com.github.wallev.maidsoulkitchen.util.ItemStackUtil;
import com.github.wallev.maidsoulkitchen.util.MemoryUtil;
import com.github.wallev.maidsoulkitchen.util.TileUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class MaidCookManager<R extends Recipe<? extends Container>> {
    protected final MaidItemDown maidItemDown = new MaidItemDown();
    protected final HubItemDown hubItemDown = new HubItemDown();
    protected final CheckRange checkRange = new CheckRange();
    protected final EntityMaid maid;
    protected final ServerLevel level;
    protected final ICookTask<?, R> task;
    protected final RecSerializerManager<R> recSerializerManager;
    protected final CookBeBase<?> cookBeBase;
    protected CookDataV1 cookData;
    protected boolean init = false;
    protected int runState = 0;
    protected List<BlockEntity> validChests = Collections.emptyList();
    protected RecsGenerate<R> recsGenerate = new RecsGenerate();
    protected IMaidCookInventory cookInv;
    protected ItemInventory itemInventory;
    protected ChestInventory chestInputInventory;
    protected ChestInventory chestOutputInventory;
    protected IItemDown itemDown = this.maidItemDown;
    protected boolean hasCulinaryHub;
    protected Map<BagType, List<BlockPos>> bindingPoses;
    protected int tryTime = 0;
    protected LinkedList<MaidRec> allMaidRecsFromChest = new LinkedList();
    protected LinkedList<MaidRec> maidRecs = new LinkedList();

    public MaidCookManager(RecSerializerManager<R> recSerializerManager, EntityMaid maid, ICookTask<?, R> task, CookBeBase<?> cookBeBase) {
        this.recSerializerManager = recSerializerManager;
        this.maid = maid;
        this.level = (ServerLevel)maid.f_19853_;
        this.task = task;
        this.cookBeBase = cookBeBase;
    }

    public RecSerializerManager<R> getRecSerializerManager() {
        return this.recSerializerManager;
    }

    public boolean hasMaidRecs(CookBeBase<?> cookBeBase) {
        return !this.maidRecs.isEmpty();
    }

    public MaidRec pollMaidRec(CookBeBase<?> cookBeBase) {
        MaidRec maidRec = this.maidRecs.poll();
        assert (maidRec != null);
        BubbleUtil.makeResultsBubble(this.maid, maidRec);
        return maidRec;
    }

    public Map<ItemDefinition, LinkedList<ItemStack>> getInvIngredients() {
        return this.getItemInventory().getStacksMap();
    }

    public ItemInventory getItemInventory() {
        return this.getCookInv().getItemInventory();
    }

    public void updateInvIngredients() {
        this.getItemInventory().update();
    }

    private boolean initInvData() {
        if (this.cookInv == null || this.bindingPoses == null || !this.hasCulinaryHub && !this.findCulinaryHub().m_41619_()) {
            this.hasCulinaryHub = !this.findCulinaryHub().m_41619_();
            this.bindingPoses = ItemCulinaryHub.getBindPoses(this.findCulinaryHub());
            this.cookInv = this.initCookInv();
            this.chestInputInventory = new ChestInventory();
            this.chestOutputInventory = new ChestInventory();
            return true;
        }
        return false;
    }

    private IMaidCookInventory initCookInv() {
        ItemStack culinaryHub;
        if (this.canHub() && !(culinaryHub = this.findCulinaryHub()).m_41619_()) {
            return new MaidCookBagInventory(this.maid, culinaryHub);
        }
        return new MaidInventory(this.maid);
    }

    public ItemStack findCulinaryHub() {
        return ItemCulinaryHub.getItem(this.maid);
    }

    private void itemCookBag2Chest(BagType bagType, boolean requireHasItem) {
        if (!this.canHub()) {
            return;
        }
        List<BlockPos> bindPos = this.getBindingTypePoses(bagType);
        if (bindPos.isEmpty()) {
            return;
        }
        IItemHandlerModifiable hubHandler = this.getBagContainerInv(bagType);
        ArrayList<ItemStack> hubStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < hubHandler.getSlots(); ++i) {
            ItemStack stack = hubHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            hubStacks.add(stack);
        }
        if (hubStacks.isEmpty()) {
            return;
        }
        ArrayList<IItemHandler> chestHandlers = new ArrayList<IItemHandler>();
        ArrayList<BlockPos> chestPos = new ArrayList<BlockPos>();
        this.collectChest(bindPos, chestHandlers, chestPos);
        block1: for (ItemStack hubStack : hubStacks) {
            for (IItemHandler chestHandler : chestHandlers) {
                ItemStackUtil.item2Inv(hubStack, chestHandler);
                if (!hubStack.m_41619_()) continue;
                continue block1;
            }
        }
        for (BlockPos chestPo : chestPos) {
            TileUtil.makeChanged(chestPo, (Level)this.level);
        }
        this.syncInv();
    }

    protected void collectChest(List<BlockPos> bindPos, List<IItemHandler> chestHandlers, List<BlockPos> chestPos) {
        for (BlockPos pos : bindPos) {
            IItemHandler beInv;
            BlockEntity blockEntity;
            if (this.isExtraZone(pos) || (blockEntity = this.maid.f_19853_.m_7702_(pos)) == null || (beInv = ItemCulinaryHub.getBeInv(blockEntity)) == null) continue;
            chestHandlers.add(beInv);
            chestPos.add(pos);
        }
    }

    private List<BlockPos> getBindingTypePoses(BagType bagType) {
        return this.bindingPoses.getOrDefault((Object)bagType, Collections.emptyList());
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    protected List<MKRecipe<R>> getRecs() {
        List<MKRecipe<R>> list = this.getFilterRecipes(this.recsGenerate.getRecs());
        return this.shuffle(list);
    }

    protected List<MKRecipe<R>> getFilterRecipes(List<MKRecipe<R>> rec) {
        return new ArrayList<MKRecipe<R>>(rec);
    }

    public boolean checkAndInit() {
        if (this.hasCulinaryHub && this.findCulinaryHub().m_41619_()) {
            this.maidRecs = new LinkedList();
            MemoryUtil.rememberMaidRecs(this.maid, this.maidRecs);
            this.maid.refreshBrain(this.level);
            return false;
        }
        return this.init();
    }

    public void checkAndCreateRecipes() {
        if (this.runState > 0 || !this.maidRecs.isEmpty()) {
            return;
        }
        boolean lastInv = this.isLastCookInv();
        if (lastInv && this.tryTime++ < 10) {
            return;
        }
        this.createRecipesIngredients();
    }

    private boolean initTaskData() {
        if (this.cookData == null) {
            this.cookData = this.task.getTaskData(this.maid);
            this.recsGenerate.setRecs(this.getValidRecipesFor());
            return true;
        }
        return false;
    }

    private List<MKRecipe<R>> getValidRecipesFor() {
        return this.task.getRecipes((Level)this.level).stream().filter(r -> this.cookData.canCook((MKRecipe<?>)r)).toList();
    }

    private boolean isLastCookInv() {
        List<ItemStack> lastInvStack = this.cookInv.getLastInvStack();
        IItemHandlerModifiable availableInv1 = this.cookInv.getInputInv();
        if (availableInv1.getSlots() != lastInvStack.size()) {
            return false;
        }
        for (int i = 0; i < availableInv1.getSlots(); ++i) {
            ItemStack cacheStack;
            ItemStack stackInSlot = availableInv1.getStackInSlot(i);
            if (stackInSlot.m_150930_((cacheStack = lastInvStack.get(i)).m_41720_()) && stackInSlot.m_41613_() == cacheStack.m_41613_()) continue;
            return false;
        }
        return true;
    }

    protected List<BlockEntity> initChestData() {
        List<BlockPos> ingredientPos = this.getBindingTypePoses(BagType.INGREDIENT);
        if (ingredientPos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BlockPos> validPoses = new ArrayList<BlockPos>();
        ArrayList<BlockEntity> validBlockEntities = new ArrayList<BlockEntity>();
        ArrayList<IItemHandler> validItemHandlers = new ArrayList<IItemHandler>();
        int beSlots = 0;
        for (BlockPos ingredientPo : ingredientPos) {
            IItemHandler beInv;
            BlockEntity blockEntity;
            if (this.isExtraZone(ingredientPo) || (blockEntity = this.level.m_7702_(ingredientPo)) == null || (beInv = ItemCulinaryHub.getBeInv(blockEntity)) == null) continue;
            validPoses.add(ingredientPo);
            validBlockEntities.add(blockEntity);
            validItemHandlers.add(beInv);
            beSlots += beInv.getSlots();
        }
        if (beSlots == 0) {
            return Collections.emptyList();
        }
        ChestInvsData chestInvsData = new ChestInvsData(validPoses, validBlockEntities, validItemHandlers, beSlots);
        this.chestInputInventory.init(chestInvsData);
        return validBlockEntities;
    }

    public void startCollectChestIngredient() {
        if (this.chestInputInventory.needReUpdate()) {
            this.validChests = this.initChestData();
            if (this.validChests.isEmpty()) {
                return;
            }
        }
        this.runState = 1;
        MemoryUtil.makeCollectChestItemHandler(this.maid);
    }

    public void startGenerateRecs() {
        this.runState = 2;
        this.itemDown = this.hubItemDown;
        this.itemDown.clear();
        this.recsGenerate.setCurrentRecs(this.getRecs());
        this.initConditions();
        ItemInventory chestItemInventory = this.chestInputInventory.getItemInventory();
        HashMap<ItemDefinition, Long> available = new HashMap<ItemDefinition, Long>(chestItemInventory.getStacks());
        this.recsGenerate.setAvailable(available);
        MemoryUtil.makeGenerateRecs(this.maid);
    }

    public boolean recsGenDoneAndUpdate() {
        this.runState = 3;
        if (this.itemDown instanceof HubItemDown) {
            if (this.maidRecs.isEmpty()) {
                this.resetState();
                this.makeResultsBubble();
                return false;
            }
            Map<ItemDefinition, Integer> useItemDef = this.itemDown.getUseItemDef();
            IItemHandlerModifiable inputInv = this.cookInv.getInputInv();
            this.extractedChestItem2Bag(useItemDef, this.chestInputInventory.getItemInventory(), inputInv, false);
            int recLimitIndex = this.itemDown.getRecLimitIndex();
            if (recLimitIndex > this.maidRecs.size()) {
                this.allMaidRecsFromChest = new LinkedList<MaidRec>(this.maidRecs);
                this.maidRecs = new LinkedList(this.maidRecs.subList(0, recLimitIndex));
            }
            this.syncInv();
            for (BlockEntity be : this.validChests) {
                TileUtil.makeChanged(be);
            }
            this.chestIngredientDone();
        }
        MemoryUtil.rememberMaidRecs(this.maid, this.maidRecs);
        this.resetState();
        this.cookInv.calcAvailableSlots();
        this.makeResultsBubble();
        this.setNextCheckTickCount(0);
        return true;
    }

    private void extractedChestItem2Bag(Map<ItemDefinition, Integer> useItemDef, ItemInventory itemInventory1, IItemHandlerModifiable inputInv, boolean simulate) {
        block0: for (Map.Entry<ItemDefinition, Integer> entry : useItemDef.entrySet()) {
            ItemDefinition itemDefinition = entry.getKey();
            Integer amount = entry.getValue();
            LinkedList<ItemStack> itemStacks = itemInventory1.getItemStacks(itemDefinition);
            for (ItemStack itemStack : itemStacks) {
                ItemStack leftStack;
                ItemStack copy;
                if (itemStack == null || itemStack.m_41619_()) continue;
                int stackCount = itemStack.m_41613_();
                if (stackCount >= amount) {
                    copy = itemStack.m_255036_(amount.intValue());
                    leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)copy, (boolean)false);
                    if (simulate) continue block0;
                    itemStack.m_41774_(copy.m_41613_() - leftStack.m_41613_());
                    continue block0;
                }
                copy = itemStack.m_41777_();
                leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inputInv, (ItemStack)copy, (boolean)false);
                if (!simulate) {
                    itemStack.m_41774_(copy.m_41613_() - leftStack.m_41613_());
                }
                if ((amount = Integer.valueOf(amount - stackCount)) > 0) continue;
                continue block0;
            }
        }
    }

    private boolean isExtraZone(BlockPos ingredientPo) {
        return ItemCulinaryHub.isExtraZone(this.maid, ingredientPo);
    }

    private boolean init() {
        boolean initTaskData = this.initTaskData();
        boolean initInvData = this.initInvData();
        if (initTaskData || initInvData) {
            this.init = true;
            this.maidRecs = new LinkedList();
            MemoryUtil.rememberMaidRecs(this.maid, this.maidRecs);
            return false;
        }
        return true;
    }

    public boolean inited() {
        return this.init;
    }

    private void createRecipesIngredients() {
        this.clear();
        this.itemUnIngre2Chest();
        if (this.canHub()) {
            this.startCollectChestIngredient();
        } else {
            this.itemDown = this.maidItemDown;
            this.itemDown.clear();
            this.cookInv.refreshInv();
            this.recsGenerate.setCurrentRecs(this.getRecs());
            this.createIngres();
        }
    }

    public void chestIngredientDone() {
        this.runState = 0;
        this.chestInputInventory.update();
        this.syncInv();
        this.cookInv.refreshInv();
        this.cookInv.calcAvailableSlots();
    }

    public void itemOutput2Chest() {
        this.itemCookBag2Chest(BagType.OUTPUT, false);
    }

    public void itemUnIngre2Chest() {
        this.itemCookBag2Chest(BagType.INGREDIENT, true);
    }

    protected void createIngres() {
        this.initConditions();
        HashMap<ItemDefinition, Long> available = new HashMap<ItemDefinition, Long>(this.getItemInventory().getStacks());
        this.recsGenerate.setAvailable(available);
        MemoryUtil.makeGenerateRecs(this.maid);
        this.runState = 2;
    }

    public void tickGenerateRecs() {
        List<MKRecipe<R>> mkRecipes = this.recsGenerate.tickRun();
        Map<ItemDefinition, Long> available = this.recsGenerate.getAvailable();
        LinkedList<MaidRec> maidRecs1 = this.recSerializerManager.createMaidRecs(mkRecipes, available, this::recAdd, this::recIsValid, this::doItemUse, this::doneConsumer);
        this.maidRecs.addAll(maidRecs1);
    }

    private void doneConsumer(boolean done) {
        if (done) {
            this.runState = 2;
            this.recsGenerate.markDone();
        }
    }

    private boolean doItemUse(RecDataUse recDataUse) {
        return this.itemDown.read(recDataUse);
    }

    public void makeResultsBubble() {
        if (this.maidRecs.isEmpty()) {
            BubbleUtil.makeResultsBubbleWithEmpty(this.maid);
        } else {
            BubbleUtil.makeResultsBubble(this.maid, this.maidRecs);
        }
    }

    public void initConditions() {
    }

    public void clear() {
        this.resetState();
        this.recsGenerate.clear();
        this.maidRecs.clear();
        MemoryUtil.rememberMaidRecs(this.maid, this.maidRecs);
        this.itemDown.clear();
        this.chestInputInventory.clear();
    }

    public void resetState() {
        this.tryTime = 0;
        this.runState = 0;
    }

    protected void recAdd(MKRecipe<R> r, IndexRange indexRange) {
    }

    protected boolean recIsValid(MKRecipe<R> r) {
        return true;
    }

    protected List<MKRecipe<R>> shuffle(List<MKRecipe<R>> recipes) {
        Collections.shuffle(recipes);
        return recipes;
    }

    public ItemStack getItem(Predicate<ItemStack> predicate) {
        if (this.canHub()) {
            IItemHandlerModifiable inputInv = this.getInputInv();
            ItemStack itemStack = InvUtil.getStack((IItemHandler)inputInv, predicate);
            if (!itemStack.m_41619_()) {
                return itemStack;
            }
            return this.getStackFromChest(predicate);
        }
        return InvUtil.getStack((IItemHandler)this.maid.getAvailableInv(true), predicate);
    }

    public ItemStack getItem(ItemStack stack) {
        return this.getItem(stack.m_41720_());
    }

    public ItemStack getItem(Item item) {
        return this.getItem((ItemStack itemStack) -> itemStack.m_150930_(item));
    }

    public boolean hasItem(Predicate<ItemStack> predicate) {
        return !this.getItem(predicate).m_41619_();
    }

    public boolean hasItem(ItemStack stack) {
        return !this.getItem(stack).m_41619_();
    }

    public boolean hasItem(Item item) {
        return !this.getItem(item).m_41619_();
    }

    protected ItemStack getStackFromChest(Predicate<ItemStack> predicate) {
        List<BlockPos> bindModePoses = this.getBindingTypePoses(BagType.INGREDIENT);
        for (BlockPos bindModePose : bindModePoses) {
            ItemStack itemStack1;
            IItemHandler beInv;
            BlockEntity blockEntity;
            if (this.isExtraZone(bindModePose) || (blockEntity = this.level.m_7702_(bindModePose)) == null || (beInv = ItemCulinaryHub.getBeInv(blockEntity)) == null || (itemStack1 = InvUtil.getStack(beInv, predicate)).m_41619_()) continue;
            return itemStack1;
        }
        return ItemStack.f_41583_;
    }

    public IItemHandlerModifiable getOutputInv() {
        return this.cookInv.getOutputInv();
    }

    public IItemHandlerModifiable getInputInv() {
        return this.cookInv.getInputInv();
    }

    private IItemHandlerModifiable getBagContainerInv(BagType bagType) {
        return this.cookInv.getAvailableInv(bagType);
    }

    public void syncInv() {
        this.cookInv.syncInv();
    }

    public IMaidCookInventory getCookInv() {
        return this.cookInv;
    }

    private boolean canHub() {
        return this.enableHub() && this.hasCulinaryHub;
    }

    protected boolean enableHub() {
        return true;
    }

    public ChestInventory getChestOutputInventory() {
        return this.chestOutputInventory;
    }

    public ChestInventory getChestInputInventory() {
        return this.chestInputInventory;
    }

    public int getRunState() {
        return this.runState;
    }

    public boolean recsGenerateDone() {
        return this.recsGenerate.done();
    }

    public boolean checkExtraStartConditions() {
        return this.checkRange.checkExtraStartConditions(this.maid);
    }

    public void setMaxCheckRate(int maxCheckRate) {
        this.checkRange.setMaxCheckRate(maxCheckRate);
    }

    public void setNextCheckTickCount(int nextCheckTickCount) {
        this.checkRange.setNextCheckTickCount(nextCheckTickCount);
    }
}

