/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.living;

import com.renyigesai.immortalers_delight.entities.living.SkelverfishBase;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class SkelverfishBomber
extends SkelverfishBase {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(SkelverfishBomber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(SkelverfishBomber.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(SkelverfishBomber.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 18;
    private int explosionRadius = 1;
    private int maxFireDamage = 0;

    public SkelverfishBomber(EntityType<? extends Silverfish> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createSkelverfishBomberAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            pCompound.m_128379_("powered", true);
        }
        pCompound.m_128376_("Fuse", (short)this.maxSwell);
        pCompound.m_128376_("ExtraDamage", (short)this.maxFireDamage);
        pCompound.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        pCompound.m_128379_("ignited", this.isIgnited());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)pCompound.m_128471_("powered"));
        if (pCompound.m_128425_("Fuse", 99)) {
            this.maxSwell = pCompound.m_128448_("Fuse");
        }
        if (pCompound.m_128425_("ExtraDamage", 99)) {
            this.maxFireDamage = pCompound.m_128448_("ExtraDamage");
        }
        if (pCompound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = pCompound.m_128445_("ExplosionRadius");
        }
        if (pCompound.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (!super.m_7327_(pEntity)) {
            return false;
        }
        if (pEntity instanceof LivingEntity) {
            this.ignite();
        }
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!pSource.m_269533_(DamageTypeTags.f_268415_) && !pSource.m_269533_(DamageTypeTags.f_268745_)) {
            if (pSource.m_7639_() instanceof LivingEntity && !(pSource.m_7639_() instanceof Silverfish)) {
                this.setSwellDir(-1);
            }
            return super.m_6469_(pSource, pAmount);
        }
        if (pSource.m_269533_(DamageTypeTags.f_268745_)) {
            int safeAmount = pAmount > 32767.0f ? Short.MAX_VALUE : (int)pAmount;
            this.maxFireDamage = safeAmount > this.maxFireDamage ? safeAmount : this.maxFireDamage;
        }
        return false;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_12398_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        if (this.m_21224_()) {
            ++this.swell;
            if (this.swell >= (this.maxSwell > 20 ? 20 : this.maxSwell)) {
                this.explodeCreeper();
                this.swell = 0;
            }
        }
        super.m_8119_();
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public float getSwelling(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int pState) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)pState);
    }

    public boolean isPowered() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
        super.m_8038_(pLevel, pLightning);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    public int getMaxFireDamage() {
        return this.maxFireDamage;
    }

    private void explodeCreeper() {
        if (!this.m_9236_().f_46443_) {
            float f = this.isPowered() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, Level.ExplosionInteraction.MOB);
            if (!this.m_21224_()) {
                this.m_146870_();
            }
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }
}

