/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ImmortalersDelightSignRenderer
extends SignRenderer {
    private static final String STICK = "stick";
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private static final float RENDER_SCALE = 0.6666667f;
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, 0.3333333432674408, 0.046666666865348816);
    private final Map<WoodType, SignRenderer.SignModel> signModels;
    private final Font font;

    public ImmortalersDelightSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.font = context.m_173586_();
        this.signModels = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(woodType -> woodType, woodType -> new SignRenderer.SignModel(context.m_173582_(ModelLayers.m_171291_((WoodType)woodType)))));
    }

    public void m_6922_(SignBlockEntity signBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlayColor) {
        BlockState blockState = signBlockEntity.m_58900_();
        SignBlock signBlock = (SignBlock)blockState.m_60734_();
        WoodType woodType = SignBlock.m_247329_((Block)signBlock);
        SignRenderer.SignModel signModel = this.signModels.get(woodType);
        signModel.f_112507_.f_104207_ = blockState.m_60734_() instanceof StandingSignBlock;
        this.m_278756_(signBlockEntity, poseStack, bufferSource, light, overlayColor, blockState, signBlock, woodType, (Model)signModel);
    }

    public float m_278770_() {
        return 0.6666667f;
    }

    public float m_278631_() {
        return 0.6666667f;
    }

    void m_278756_(SignBlockEntity signBlockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlayColor, BlockState blockState, SignBlock signBlock, WoodType woodType, Model signModel) {
        poseStack.m_85836_();
        this.m_276777_(poseStack, -signBlock.m_276903_(blockState), blockState);
        this.m_278784_(poseStack, bufferSource, light, overlayColor, woodType, signModel);
        this.m_278841_(signBlockEntity.m_58899_(), signBlockEntity.m_277142_(), poseStack, bufferSource, light, signBlockEntity.m_245065_(), signBlockEntity.m_245123_(), true);
        this.m_278841_(signBlockEntity.m_58899_(), signBlockEntity.m_277159_(), poseStack, bufferSource, light, signBlockEntity.m_245065_(), signBlockEntity.m_245123_(), false);
        poseStack.m_85849_();
    }

    void m_276777_(PoseStack poseStack, float rotationAngle, BlockState blockState) {
        poseStack.m_252880_(0.5f, 0.75f * this.m_278770_(), 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationAngle));
        if (!(blockState.m_60734_() instanceof StandingSignBlock)) {
            poseStack.m_252880_(0.0f, -0.3125f, -0.4375f);
        }
    }

    void m_278784_(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlayColor, WoodType woodType, Model signModel) {
        poseStack.m_85836_();
        float scale = this.m_278770_();
        poseStack.m_85841_(scale, -scale, -scale);
        Material material = this.m_245629_(woodType);
        VertexConsumer vertexConsumer = material.m_119194_(bufferSource, arg_0 -> ((Model)signModel).m_103119_(arg_0));
        this.m_245885_(poseStack, light, overlayColor, signModel, vertexConsumer);
        poseStack.m_85849_();
    }

    void m_245885_(PoseStack poseStack, int light, int overlayColor, Model signModel, VertexConsumer vertexConsumer) {
        SignRenderer.SignModel signRendererSignModel = (SignRenderer.SignModel)signModel;
        signRendererSignModel.f_173655_.m_104301_(poseStack, vertexConsumer, light, overlayColor);
    }

    Material m_245629_(WoodType woodType) {
        return Sheets.m_173381_((WoodType)woodType);
    }

    void m_278841_(BlockPos blockPos, SignText signText, PoseStack poseStack, MultiBufferSource bufferSource, int light, int lineHeight, int maxLineWidth, boolean isFrontText) {
        int renderTypeColor;
        boolean outlineVisible;
        int textColor;
        poseStack.m_85836_();
        this.m_278823_(poseStack, isFrontText, this.m_278725_());
        int darkColor = ImmortalersDelightSignRenderer.m_173639_(signText);
        int outlineOffset = 4 * lineHeight / 2;
        FormattedCharSequence[] renderMessages = signText.m_277130_(Minecraft.m_91087_().m_167974_(), message -> {
            List lines = this.font.m_92923_((FormattedText)message, maxLineWidth);
            return lines.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)lines.get(0);
        });
        if (signText.m_276843_()) {
            textColor = signText.m_276773_().m_41071_();
            outlineVisible = ImmortalersDelightSignRenderer.m_277119_(blockPos, textColor);
            renderTypeColor = 0xF000F0;
        } else {
            textColor = darkColor;
            outlineVisible = false;
            renderTypeColor = light;
        }
        for (int i = 0; i < 4; ++i) {
            FormattedCharSequence formattedMessage = renderMessages[i];
            float xOffset = -this.font.m_92724_(formattedMessage) / 2;
            if (outlineVisible) {
                this.font.m_168645_(formattedMessage, xOffset, (float)(i * lineHeight - outlineOffset), textColor, darkColor, poseStack.m_85850_().m_252922_(), bufferSource, renderTypeColor);
                continue;
            }
            this.font.m_272191_(formattedMessage, xOffset, (float)(i * lineHeight - outlineOffset), textColor, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, renderTypeColor);
        }
        poseStack.m_85849_();
    }

    private void m_278823_(PoseStack poseStack, boolean isFrontText, Vec3 textOffset) {
        if (!isFrontText) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        float scale = 0.015625f * this.m_278631_();
        poseStack.m_85837_(textOffset.f_82479_, textOffset.f_82480_, textOffset.f_82481_);
        poseStack.m_85841_(scale, -scale, scale);
    }

    Vec3 m_278725_() {
        return TEXT_OFFSET;
    }

    static boolean m_277119_(BlockPos blockPos, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localPlayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)blockPos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    static int m_173639_(SignText text) {
        int i = text.m_276773_().m_41071_();
        if (i == DyeColor.BLACK.m_41071_() && text.m_276843_()) {
            return -988212;
        }
        double d0 = 0.4;
        int j = (int)((double)FastColor.ARGB32.m_13665_((int)i) * 0.4);
        int k = (int)((double)FastColor.ARGB32.m_13667_((int)i) * 0.4);
        int l = (int)((double)FastColor.ARGB32.m_13669_((int)i) * 0.4);
        return FastColor.ARGB32.m_13660_((int)0, (int)j, (int)k, (int)l);
    }

    public static SignRenderer.SignModel m_173646_(EntityModelSet modelSet, WoodType woodType) {
        return new SignRenderer.SignModel(modelSet.m_171103_(ModelLayers.m_171291_((WoodType)woodType)));
    }

    public static LayerDefinition m_173654_() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), PartPose.f_171404_);
        partdefinition.m_171599_(STICK, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart stick;

        public SignModel(ModelPart p_173657_) {
            super(RenderType::m_110458_);
            this.root = p_173657_;
            this.stick = p_173657_.m_171324_(ImmortalersDelightSignRenderer.STICK);
        }

        public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int p_112512_, int p_112513_, float p_112514_, float p_112515_, float p_112516_, float p_112517_) {
            this.root.m_104306_(poseStack, consumer, p_112512_, p_112513_, p_112514_, p_112515_, p_112516_, p_112517_);
        }
    }
}

