/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.util.task;

import com.renyigesai.immortalers_delight.ImmortalersDelightMod;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class ScheduledExecuteTask
implements Runnable {
    private static final HashMap<Integer, ScheduledExecuteTask> TASK_LIST = new HashMap();
    private volatile boolean isRemoved = false;
    protected final int TASKID;
    private int delay;
    protected boolean cycle = this.delay >= 0;
    protected final int INITIALDELAY;
    protected final int DELAY;
    protected boolean start;
    protected boolean first;
    protected int tick;

    public ScheduledExecuteTask() {
        this(0);
    }

    public ScheduledExecuteTask(int initialDelay) {
        this(initialDelay, -1);
    }

    public ScheduledExecuteTask(int initialDelay, int delay) {
        this.TASKID = new Random().nextInt(Short.MAX_VALUE);
        this.first = true;
        this.delay = delay;
        this.tick = 0;
        this.INITIALDELAY = initialDelay;
        this.DELAY = delay;
    }

    public ScheduledExecuteTask(int initialDelay, int delay, int taskID) {
        this.TASKID = taskID;
        this.first = true;
        this.delay = delay;
        this.tick = 0;
        this.INITIALDELAY = initialDelay;
        this.DELAY = delay;
    }

    public static synchronized boolean cancel(int taskID) {
        if (TASK_LIST.containsKey(taskID)) {
            TASK_LIST.get(taskID).cancel();
            return true;
        }
        return false;
    }

    public static HashMap<Integer, ScheduledExecuteTask> getTaskMap() {
        return TASK_LIST;
    }

    public static ScheduledExecuteTask getTaskFromID(Integer id) {
        return TASK_LIST.get(id);
    }

    @SubscribeEvent
    public void onTick(@Nonnull TickEvent.ServerTickEvent evt) {
        if (evt.phase.equals((Object)TickEvent.Phase.START)) {
            ++this.tick;
            if (this.first) {
                if (this.tick >= this.INITIALDELAY) {
                    this.first = false;
                    this.tick = 0;
                    this.run();
                }
            } else if (this.delay >= 0) {
                if (this.tick >= this.DELAY) {
                    this.tick = 0;
                    this.run();
                }
            } else {
                ImmortalersDelightMod.LOGGER.info("\u5b69\u5b50\u4eec\uff0c\u6211\u5df2\u7ecf\u8d85\u65f6\u4e86\uff0c\u4f46\u6211\u8fd8\u5728\u8dd1");
                this.cancel();
            }
        }
    }

    public int getTaskID() {
        return this.TASKID;
    }

    public synchronized void start() {
        if (!this.start) {
            this.start = true;
            TASK_LIST.put(this.getTaskID(), this);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public synchronized void cancel() {
        this.start = false;
        TASK_LIST.remove(this.getTaskID());
        ImmortalersDelightMod.LOGGER.info("\u6211\u662fTask\uff0c\u5b69\u5b50\u4eec\u6211\u88ab\u53d6\u6d88\u4e86");
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public void stop() {
        this.delay = -1;
    }
}

