/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.potion;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.immortalers_delight.event.DifficultyModeHelper;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import java.util.List;
import java.util.Objects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CoolPotionEffect {
    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        if (event != null && event.getEntity() != null) {
            ItemStack stack = event.getResultStack();
            LivingEntity livingEntity = event.getEntity();
            if (stack.m_41720_().m_41472_() && livingEntity.m_21023_((MobEffect)ImmortalersDelightMobEffect.COOL.get()) && CoolPotionEffect.noCoolFood(stack, livingEntity)) {
                int lv = livingEntity.m_21023_((MobEffect)ImmortalersDelightMobEffect.COOL.get()) ? livingEntity.m_21124_((MobEffect)ImmortalersDelightMobEffect.COOL.get()).m_19564_() : 0;
                int time = livingEntity.m_21023_(MobEffects.f_19606_) ? livingEntity.m_21124_(MobEffects.f_19606_).m_19557_() : 0;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, time + (lv > 3 ? 100 * lv : 100), Math.min(lv, 3)));
            }
        }
    }

    @SubscribeEvent
    public static void onCreatureHurt(LivingHurtEvent evt) {
        if (evt.isCanceled() || evt.getSource().m_269533_(DamageTypeTags.f_268630_)) {
            return;
        }
        LivingEntity hurtOne = evt.getEntity();
        if (!(hurtOne.m_9236_().f_46443_ || !DifficultyModeHelper.isPowerBattleMode() || evt.getSource().m_269533_(DamageTypeTags.f_268490_) && evt.getSource().m_269533_(DamageTypeTags.f_276146_) || !hurtOne.m_21023_((MobEffect)ImmortalersDelightMobEffect.COOL.get()))) {
            int lv = hurtOne.m_21124_((MobEffect)ImmortalersDelightMobEffect.COOL.get()).m_19564_();
            float buffer = hurtOne.m_20094_() <= 1 ? (float)(0.9675 * Math.exp(-0.0372 * (double)lv)) : (float)(0.9344 * Math.exp(-0.1154 * (double)(++lv)));
            evt.setAmount(Math.min(evt.getAmount() * buffer, evt.getAmount()));
        }
    }

    public static boolean noCoolFood(ItemStack stack, LivingEntity entity) {
        List effects = Objects.requireNonNull(stack.getFoodProperties(entity)).m_38749_();
        for (Pair effect : effects) {
            if (((MobEffectInstance)effect.getFirst()).m_19544_() != ImmortalersDelightMobEffect.COOL.get()) continue;
            return false;
        }
        return true;
    }
}

