/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.dependencies.jei.category;

import io.github.tt432.kitchenkarrot.dependencies.jei.JeiPlugin;
import io.github.tt432.kitchenkarrot.dependencies.jei.category.BaseRecipeCategory;
import io.github.tt432.kitchenkarrot.item.ModBlockItems;
import io.github.tt432.kitchenkarrot.recipes.recipe.BrewingBarrelRecipe;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BrewingBarrelRecipeCategory
extends BaseRecipeCategory<BrewingBarrelRecipe> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("kitchenkarrot", "textures/gui/jei.png");

    public BrewingBarrelRecipeCategory(IGuiHelper helper) {
        super(JeiPlugin.BREWING_BARREL, helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlockItems.BREWING_BARREL.get())), (IDrawable)helper.createDrawable(BACKGROUND, 0, 72, 149, 69));
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, BrewingBarrelRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.getIngredient();
        builder.addSlot(RecipeIngredientRole.INPUT, 42, 17).addIngredients((Ingredient)ingredients.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 17).addIngredients((Ingredient)ingredients.get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 82, 17).addIngredients((Ingredient)ingredients.get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 42, 37).addIngredients((Ingredient)ingredients.get(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 37).addIngredients((Ingredient)ingredients.get(4));
        builder.addSlot(RecipeIngredientRole.INPUT, 82, 37).addIngredients((Ingredient)ingredients.get(5));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 27).addItemStack(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
    }

    public List<Component> getTooltipStrings(BrewingBarrelRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 20.0 && mouseX <= 38.0) {
            if (mouseY >= 16.0 && mouseY <= 34.0) {
                return List.of(Component.m_237110_((String)"info.kitchenkarrot.water", (Object[])new Object[]{recipe.getWaterConsumption()}));
            }
            if (mouseY >= 36.0 && mouseY <= 54.0) {
                return List.of(Component.m_237110_((String)"info.kitchenkarrot.time", (Object[])new Object[]{recipe.getCraftingTime() / 20}));
            }
        }
        return Collections.emptyList();
    }
}

