/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.blockentity.sync;

import io.github.tt432.kitchenkarrot.blockentity.sync.SyncData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class SyncDataManager {
    private final List<SyncData<?>> syncDataList = new ArrayList();

    public <T, S extends SyncData<T>> S add(S syncData) {
        this.syncDataList.add(syncData);
        return syncData;
    }

    public void remove(SyncData<?> syncData) {
        this.syncDataList.remove(syncData);
    }

    public void load(CompoundTag pTag, boolean sync) {
        if (sync) {
            this.syncDataList.forEach(data -> data.load(pTag));
        } else {
            this.syncDataList.forEach(data -> {
                if (data.needSave) {
                    data.load(pTag);
                }
            });
        }
    }

    public void save(CompoundTag pTag, boolean sync, boolean force) {
        if (sync) {
            this.syncDataList.forEach(data -> data.save(pTag, force));
        } else {
            this.syncDataList.forEach(data -> {
                if (data.needSave) {
                    data.save(pTag, force);
                }
            });
        }
    }
}

