/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.block;

import io.github.tt432.kitchenkarrot.block.ModBaseEntityBlock;
import io.github.tt432.kitchenkarrot.block.PlateHolderMap;
import io.github.tt432.kitchenkarrot.blockentity.PlateBlockEntity;
import io.github.tt432.kitchenkarrot.recipes.recipe.PlateRecipe;
import io.github.tt432.kitchenkarrot.registries.ModBlockEntities;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import io.github.tt432.kitchenkarrot.registries.ModSoundEvents;
import io.github.tt432.kitchenkarrot.registries.RecipeTypes;
import io.github.tt432.kitchenkarrot.tag.ModItemTags;
import io.github.tt432.kitchenkarrot.util.ItemHandlerUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class PlateBlock
extends ModBaseEntityBlock<PlateBlockEntity> {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    public static final BooleanProperty CREATIVE = BooleanProperty.m_61465_((String)"creative");
    public static final IntegerProperty DEGREE = IntegerProperty.m_61631_((String)"degree", (int)0, (int)360);

    public PlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CREATIVE, (Comparable)Boolean.valueOf(false)));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)DEGREE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockEntityType<PlateBlockEntity> getBlockEntity() {
        return (BlockEntityType)ModBlockEntities.PLATE.get();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AtomicBoolean success = new AtomicBoolean(false);
        BlockEntity blockEntity = level.m_7702_(pos);
        if ((!((Boolean)state.m_61143_((Property)CREATIVE)).booleanValue() || player.m_7500_()) && blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                ItemStack heldItem = player.m_21120_(hand);
                ItemStack dishItem = handler.getStackInSlot(0);
                if (player.m_6144_()) {
                    if (heldItem.m_41619_()) {
                        ItemStack stack = new ItemStack((ItemLike)this);
                        blockEntity.m_187476_(stack);
                        PlateBlock.setPlate(stack, dishItem);
                        if (stack.m_41784_().m_128441_("plate_type") && !dishItem.m_150930_(Items.f_41852_)) {
                            String inputName = dishItem.m_41611_().getString().replace("[", "").replace("]", "");
                            stack.m_41714_((Component)Component.m_237110_((String)"info.kitchenkarrot.dished", (Object[])new Object[]{inputName}).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false))));
                        }
                        player.m_21008_(hand, stack);
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                    }
                } else if (hand == InteractionHand.MAIN_HAND) {
                    success.set(this.interactWithDish(dishItem, heldItem, level, player, (IItemHandler)handler, pos));
                } else if (!heldItem.m_41619_() && !success.get()) {
                    success.set(this.interactWithDish(dishItem, heldItem, level, player, (IItemHandler)handler, pos));
                }
            });
        }
        if (success.get()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean canHoldItem(IItemHandler handler, ItemStack heldItem) {
        ItemStack dishItem = handler.getStackInSlot(0);
        return PlateHolderMap.plateHolder.containsKey(heldItem.m_41720_()) && (dishItem.m_41619_() || dishItem.m_150930_(heldItem.m_41720_()) && dishItem.m_41613_() < PlateHolderMap.plateHolder.get(dishItem.m_41720_()));
    }

    private boolean interactWithDish(ItemStack dishItem, ItemStack heldItem, Level level, Player player, IItemHandler handler, BlockPos pos) {
        AtomicBoolean result = new AtomicBoolean(false);
        if (this.canHoldItem(handler, heldItem)) {
            result.set(this.addToPlate(handler, heldItem, player));
            level.m_247517_(player, pos, SoundEvents.f_12013_, SoundSource.BLOCKS);
        } else if (!dishItem.m_41619_() && heldItem.m_41619_() || heldItem.m_204117_(ModItemTags.INTERACT_WITH_PLATE)) {
            result.set(this.removeFromPlate(level, player, handler, dishItem, heldItem));
            level.m_247517_(player, pos, SoundEvents.f_12016_, SoundSource.BLOCKS);
        }
        return result.get();
    }

    private boolean removeFromPlate(Level level, Player player, IItemHandler handler, ItemStack input, ItemStack heldItem) {
        Optional<PlateRecipe> recipe = level.m_7465_().m_44013_((RecipeType)RecipeTypes.PLATE.get()).stream().filter(r -> r.matches(Collections.singletonList(input)) && r.canCut(heldItem, input)).findFirst();
        AtomicBoolean result = new AtomicBoolean(false);
        recipe.ifPresent(r -> {
            if (this.giveRecipeResult((PlateRecipe)r, handler)) {
                level.m_5594_(player, player.m_20097_(), (SoundEvent)ModSoundEvents.CHOP.get(), player.m_5720_(), 0.5f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
                result.set(true);
            }
        });
        if (recipe.isEmpty()) {
            ItemHandlerUtils.extractSingle(handler, 0, player);
            result.set(true);
        }
        return result.get();
    }

    private boolean addToPlate(IItemHandler handler, ItemStack heldItem, Player player) {
        AtomicBoolean result = new AtomicBoolean(false);
        ItemHandlerUtils.insertSingle(handler, 0, player, heldItem);
        result.set(true);
        return result.get();
    }

    private boolean giveRecipeResult(PlateRecipe recipe, IItemHandler handler) {
        AtomicBoolean result = new AtomicBoolean(false);
        handler.extractItem(0, 64, false);
        handler.insertItem(0, recipe.getResultStack(), false);
        result.set(true);
        return result.get();
    }

    public static void setPlate(ItemStack self, ItemStack content) {
        self.m_41784_().m_128405_("plate_amount", content.m_41613_());
        if (ForgeRegistries.ITEMS.getKey((Object)content.m_41720_()) != null) {
            self.m_41784_().m_128359_("plate_type", ForgeRegistries.ITEMS.getKey((Object)content.m_41720_()).toString());
        }
    }

    @Override
    public List<ItemStack> m_49635_(BlockState p_287732_, LootParams.Builder p_287596_) {
        return List.of(new ItemStack((ItemLike)ModItems.PLATE_PIECES.get()));
    }

    protected void m_142387_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState) {
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        pLevel.m_5594_(null, pPos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CREATIVE});
        builder.m_61104_(new Property[]{DEGREE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() == null || !context.m_43723_().m_6144_()) {
            int rotation = (int)context.m_7074_();
            if (context.m_43725_().f_46443_) {
                while (rotation >= 180 || rotation < -180) {
                    if (rotation >= 180) {
                        rotation -= 360;
                    }
                    if (rotation >= -180) continue;
                    rotation += 360;
                }
            }
            return (BlockState)this.m_49966_().m_61124_((Property)DEGREE, (Comparable)Integer.valueOf(rotation + 180));
        }
        int direction = 0;
        switch (context.m_8125_()) {
            case NORTH: {
                direction = 0;
                break;
            }
            case EAST: {
                direction = 90;
                break;
            }
            case SOUTH: {
                direction = 180;
                break;
            }
            case WEST: {
                direction = 270;
            }
        }
        return (BlockState)this.m_49966_().m_61124_((Property)DEGREE, (Comparable)Integer.valueOf(direction));
    }
}

