/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.world.growers;

import com.fruitstack.fruitstack.common.block.BlockFruitCrop;
import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PeachTreeFeatureSapling
extends Feature<NoneFeatureConfiguration> {
    public PeachTreeFeatureSapling(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)pContext.config();
        WorldGenLevel world = pContext.level();
        ChunkGenerator generator = pContext.chunkGenerator();
        RandomSource random = pContext.random();
        BlockPos pos = pContext.origin();
        return this.place(config, world, generator, random, pos);
    }

    public boolean place(NoneFeatureConfiguration config, WorldGenLevel world, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        if (this.isValidGround(world.getBlockState(pos.below()), (BlockGetter)world, pos) && world.getBlockState(pos).canBeReplaced()) {
            int type = 1;
            PeachTreeFeatureSapling.generateTree(world, pos, random, type);
            return true;
        }
        return false;
    }

    private boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Block block = state.getBlock();
        return block == Blocks.GRASS_BLOCK || block == Blocks.DIRT || block == Blocks.COARSE_DIRT || block == Blocks.PODZOL;
    }

    public static void generateTree(WorldGenLevel world, BlockPos pos, RandomSource random, int verify) {
        BlockState trunk = PeachTreeFeatureSapling.getTrunk();
        BlockState trunktwo = PeachTreeFeatureSapling.getTrunkTwo();
        BlockState leaves = PeachTreeFeatureSapling.getLeaves();
        BlockState fruit = PeachTreeFeatureSapling.getFruit(verify, random);
        world.setBlock(pos.above(0), trunk, 3);
        world.setBlock(pos.above(1), trunktwo, 3);
        if (world.getBlockState(pos.above(2).north().east()).canBeReplaced()) {
            world.setBlock(pos.above(2).north().east(), fruit, 3);
        }
        if (world.getBlockState(pos.above(2).north().west()).canBeReplaced()) {
            world.setBlock(pos.above(2).north().west(), fruit, 3);
        }
        if (world.getBlockState(pos.above(2).south().east()).canBeReplaced()) {
            world.setBlock(pos.above(2).south().east(), fruit, 3);
        }
        if (world.getBlockState(pos.above(2).south().west()).canBeReplaced()) {
            world.setBlock(pos.above(2).south().west(), fruit, 3);
        }
        if (world.getBlockState(pos.above(2)).canBeReplaced()) {
            world.setBlock(pos.above(2), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).north()).canBeReplaced()) {
            world.setBlock(pos.above(2).north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).south()).canBeReplaced()) {
            world.setBlock(pos.above(2).south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).east()).canBeReplaced()) {
            world.setBlock(pos.above(2).east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).west()).canBeReplaced()) {
            world.setBlock(pos.above(2).west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).north().north()).canBeReplaced()) {
            world.setBlock(pos.above(2).north().north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).south().south()).canBeReplaced()) {
            world.setBlock(pos.above(2).south().south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).east().east()).canBeReplaced()) {
            world.setBlock(pos.above(2).east().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).west().west()).canBeReplaced()) {
            world.setBlock(pos.above(2).west().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).north().east().north()).canBeReplaced()) {
            world.setBlock(pos.above(2).north().east().north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).north().east().east()).canBeReplaced()) {
            world.setBlock(pos.above(2).north().east().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).north().west().north()).canBeReplaced()) {
            world.setBlock(pos.above(2).north().west().north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).north().west().west()).canBeReplaced()) {
            world.setBlock(pos.above(2).north().west().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).south().east().south()).canBeReplaced()) {
            world.setBlock(pos.above(2).south().east().south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).south().east().east()).canBeReplaced()) {
            world.setBlock(pos.above(2).south().east().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).south().west().south()).canBeReplaced()) {
            world.setBlock(pos.above(2).south().west().south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(2).south().west().west()).canBeReplaced()) {
            world.setBlock(pos.above(2).south().west().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3)).canBeReplaced()) {
            world.setBlock(pos.above(3), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).north()).canBeReplaced()) {
            world.setBlock(pos.above(3).north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).south()).canBeReplaced()) {
            world.setBlock(pos.above(3).south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).east()).canBeReplaced()) {
            world.setBlock(pos.above(3).east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).west()).canBeReplaced()) {
            world.setBlock(pos.above(3).west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).north().east()).canBeReplaced()) {
            world.setBlock(pos.above(3).north().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).south().east()).canBeReplaced()) {
            world.setBlock(pos.above(3).south().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).north().west()).canBeReplaced()) {
            world.setBlock(pos.above(3).north().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(3).south().west()).canBeReplaced()) {
            world.setBlock(pos.above(3).south().west(), leaves, 3);
        }
    }

    private static BlockState getLeaves() {
        return (BlockState)((BlockState)((Block)ModBlocks.PEACH_LEAVES.get()).defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
    }

    private static BlockState getTrunk() {
        return ((Block)ModBlocks.PEACH_LOG_BIG.get()).defaultBlockState();
    }

    private static BlockState getTrunkTwo() {
        return ((Block)ModBlocks.PEACH_LOG_TOP.get()).defaultBlockState();
    }

    public static BlockState getFruit(int verify, RandomSource random) {
        int i = 0;
        switch (verify) {
            case 1: {
                return (BlockState)((BlockFruitCrop)((Object)ModBlocks.PEACH_CROP.get())).defaultBlockState().setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(i));
            }
        }
        return (BlockState)((BlockFruitCrop)((Object)ModBlocks.PEACH_CROP.get())).defaultBlockState().setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(i));
    }
}

