/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.world.growers;

import com.fruitstack.fruitstack.common.block.BlockFruitCrop;
import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class LitchiTreeFeatureSapling
extends Feature<NoneFeatureConfiguration> {
    public LitchiTreeFeatureSapling(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)pContext.config();
        WorldGenLevel world = pContext.level();
        ChunkGenerator generator = pContext.chunkGenerator();
        RandomSource random = pContext.random();
        BlockPos pos = pContext.origin();
        return this.place(config, world, generator, random, pos);
    }

    public boolean place(NoneFeatureConfiguration config, WorldGenLevel world, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        if (this.isValidGround(world.getBlockState(pos.below()), (BlockGetter)world, pos) && world.getBlockState(pos).canBeReplaced()) {
            int type = 1;
            LitchiTreeFeatureSapling.generateTree(world, pos, random, type);
            return true;
        }
        return false;
    }

    private boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Block block = state.getBlock();
        return block == Blocks.GRASS_BLOCK || block == Blocks.DIRT || block == Blocks.COARSE_DIRT || block == Blocks.PODZOL;
    }

    public static void generateTree(WorldGenLevel world, BlockPos pos, RandomSource random, int verify) {
        BlockState trunk = LitchiTreeFeatureSapling.getTrunk();
        BlockState trunktwo = LitchiTreeFeatureSapling.getTrunkTwo();
        BlockState trunkthree = LitchiTreeFeatureSapling.getTrunkThree();
        BlockState trunkfour = LitchiTreeFeatureSapling.getTrunkFour();
        BlockState leaves = LitchiTreeFeatureSapling.getLeaves();
        BlockState fruit = LitchiTreeFeatureSapling.getFruit(verify, random);
        world.setBlock(pos.above(0), trunk, 3);
        world.setBlock(pos.above(1), trunk, 3);
        world.setBlock(pos.above(2), trunktwo, 3);
        world.setBlock(pos.above(3), trunktwo, 3);
        world.setBlock(pos.above(4), trunkthree, 3);
        world.setBlock(pos.above(5), trunkfour, 3);
        if (world.getBlockState(pos.above(5).north().north()).canBeReplaced()) {
            world.setBlock(pos.above(5).north().north(), fruit, 3);
        }
        if (world.getBlockState(pos.above(5).north().east()).canBeReplaced()) {
            world.setBlock(pos.above(5).north().east(), fruit, 3);
        }
        if (world.getBlockState(pos.above(5).north().west()).canBeReplaced()) {
            world.setBlock(pos.above(5).north().west(), fruit, 3);
        }
        if (world.getBlockState(pos.above(5).south().south()).canBeReplaced()) {
            world.setBlock(pos.above(5).south().south(), fruit, 3);
        }
        if (world.getBlockState(pos.above(5).south().east()).canBeReplaced()) {
            world.setBlock(pos.above(5).south().east(), fruit, 3);
        }
        if (world.getBlockState(pos.above(5).south().west()).canBeReplaced()) {
            world.setBlock(pos.above(5).south().west(), fruit, 3);
        }
        if (world.getBlockState(pos.above(5).east().east()).canBeReplaced()) {
            world.setBlock(pos.above(5).east().east(), fruit, 3);
        }
        if (world.getBlockState(pos.above(5).west().west()).canBeReplaced()) {
            world.setBlock(pos.above(5).west().west(), fruit, 3);
        }
        if (world.getBlockState(pos.above(6)).canBeReplaced()) {
            world.setBlock(pos.above(6), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north()).canBeReplaced()) {
            world.setBlock(pos.above(6).north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south()).canBeReplaced()) {
            world.setBlock(pos.above(6).south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).east()).canBeReplaced()) {
            world.setBlock(pos.above(6).east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).west()).canBeReplaced()) {
            world.setBlock(pos.above(6).west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north().east()).canBeReplaced()) {
            world.setBlock(pos.above(6).north().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north().west()).canBeReplaced()) {
            world.setBlock(pos.above(6).north().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south().east()).canBeReplaced()) {
            world.setBlock(pos.above(6).south().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south().west()).canBeReplaced()) {
            world.setBlock(pos.above(6).south().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north().north()).canBeReplaced()) {
            world.setBlock(pos.above(6).north().north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south().south()).canBeReplaced()) {
            world.setBlock(pos.above(6).south().south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).east().east()).canBeReplaced()) {
            world.setBlock(pos.above(6).east().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).west().west()).canBeReplaced()) {
            world.setBlock(pos.above(6).west().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north().east().north()).canBeReplaced()) {
            world.setBlock(pos.above(6).north().east().north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north().east().east()).canBeReplaced()) {
            world.setBlock(pos.above(6).north().east().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north().west().north()).canBeReplaced()) {
            world.setBlock(pos.above(6).north().west().north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).north().west().west()).canBeReplaced()) {
            world.setBlock(pos.above(6).north().west().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south().east().south()).canBeReplaced()) {
            world.setBlock(pos.above(6).south().east().south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south().east().east()).canBeReplaced()) {
            world.setBlock(pos.above(6).south().east().east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south().west().south()).canBeReplaced()) {
            world.setBlock(pos.above(6).south().west().south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(6).south().west().west()).canBeReplaced()) {
            world.setBlock(pos.above(6).south().west().west(), leaves, 3);
        }
        if (world.getBlockState(pos.above(7)).canBeReplaced()) {
            world.setBlock(pos.above(7), leaves, 3);
        }
        if (world.getBlockState(pos.above(7).north()).canBeReplaced()) {
            world.setBlock(pos.above(7).north(), leaves, 3);
        }
        if (world.getBlockState(pos.above(7).south()).canBeReplaced()) {
            world.setBlock(pos.above(7).south(), leaves, 3);
        }
        if (world.getBlockState(pos.above(7).east()).canBeReplaced()) {
            world.setBlock(pos.above(7).east(), leaves, 3);
        }
        if (world.getBlockState(pos.above(7).west()).canBeReplaced()) {
            world.setBlock(pos.above(7).west(), leaves, 3);
        }
    }

    private static BlockState getLeaves() {
        return (BlockState)((BlockState)((Block)ModBlocks.LITCHI_LEAVES.get()).defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
    }

    private static BlockState getTrunk() {
        return ((Block)ModBlocks.LITCHI_LOG_BIG.get()).defaultBlockState();
    }

    private static BlockState getTrunkTwo() {
        return ((Block)ModBlocks.LITCHI_LOG_MEDIUM.get()).defaultBlockState();
    }

    private static BlockState getTrunkThree() {
        return ((Block)ModBlocks.LITCHI_LOG_BIFURCATE.get()).defaultBlockState();
    }

    private static BlockState getTrunkFour() {
        return ((Block)ModBlocks.LITCHI_LOG_TOP.get()).defaultBlockState();
    }

    public static BlockState getFruit(int verify, RandomSource random) {
        int i = 0;
        switch (verify) {
            case 1: {
                return (BlockState)((BlockFruitCrop)((Object)ModBlocks.LITCHI_CROP.get())).defaultBlockState().setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(i));
            }
        }
        return (BlockState)((BlockFruitCrop)((Object)ModBlocks.LITCHI_CROP.get())).defaultBlockState().setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(i));
    }
}

