/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.world.filter;

import com.fruitstack.fruitstack.common.registry.ModPlacementModifiers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeTagFilter
extends PlacementFilter {
    public static final Codec<BiomeTagFilter> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.codec((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey()).fieldOf("tag").forGetter(instance -> instance.biomeTag)).apply((Applicative)builder, BiomeTagFilter::new));
    private final TagKey<Biome> biomeTag;

    private BiomeTagFilter(TagKey<Biome> biomeTag) {
        this.biomeTag = biomeTag;
    }

    public static BiomeTagFilter biomeIsInTag(TagKey<Biome> biomeTag) {
        return new BiomeTagFilter(biomeTag);
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos pos) {
        Holder biome = context.getLevel().getBiome(pos);
        return biome.is(this.biomeTag);
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)ModPlacementModifiers.BIOME_TAG.get();
    }
}

