/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.utility;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextUtils {
    private static final MutableComponent NO_EFFECTS = Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY);

    public static MutableComponent getTranslation(String key, Object ... args) {
        return Component.translatable((String)("fruitstack." + key), (Object[])args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addFoodEffectTooltip(ItemStack itemIn, List<Component> lores, float durationFactor) {
        FoodProperties foodStats = itemIn.getItem().getFoodProperties();
        if (foodStats == null) {
            return;
        }
        List effectList = foodStats.getEffects();
        ArrayList attributeList = Lists.newArrayList();
        if (effectList.isEmpty()) {
            lores.add((Component)NO_EFFECTS);
        } else {
            for (Pair effectPair : effectList) {
                MobEffectInstance instance = (MobEffectInstance)effectPair.getFirst();
                MutableComponent iformattabletextcomponent = Component.translatable((String)instance.getDescriptionId());
                MobEffect effect = instance.getEffect();
                Map attributeMap = effect.getAttributeModifiers();
                if (!attributeMap.isEmpty()) {
                    for (Map.Entry entry : attributeMap.entrySet()) {
                        AttributeModifier rawModifier = (AttributeModifier)entry.getValue();
                        AttributeModifier modifier = new AttributeModifier(rawModifier.getName(), effect.getAttributeModifierValue(instance.getAmplifier(), rawModifier), rawModifier.getOperation());
                        attributeList.add(new Pair((Object)((Attribute)entry.getKey()), (Object)modifier));
                    }
                }
                if (instance.getAmplifier() > 0) {
                    iformattabletextcomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.translatable((String)("potion.potency." + instance.getAmplifier()))});
                }
                if (instance.getDuration() > 20) {
                    iformattabletextcomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)durationFactor)});
                }
                lores.add((Component)iformattabletextcomponent.withStyle(effect.getCategory().getTooltipFormatting()));
            }
        }
        if (!attributeList.isEmpty()) {
            lores.add(CommonComponents.EMPTY);
            lores.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attributeList) {
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double amount = modifier.getAmount();
                double formattedAmount = modifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier.getAmount() : modifier.getAmount() * 100.0;
                if (amount > 0.0) {
                    lores.add((Component)Component.translatable((String)("attribute.modifier.plus." + modifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                lores.add((Component)Component.translatable((String)("attribute.modifier.take." + modifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount *= -1.0), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }
}

