/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.item;

import com.fruitstack.fruitstack.common.item.ConsumableItem;
import com.fruitstack.fruitstack.common.utility.TextUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BestWineItem
extends ConsumableItem {
    public BestWineItem(Item.Properties properties) {
        super(properties);
    }

    public BestWineItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip);
    }

    public BestWineItem(Item.Properties properties, boolean hasPotionEffectTooltip, boolean hasCustomTooltip) {
        super(properties, hasPotionEffectTooltip, hasCustomTooltip);
    }

    public int getUseDuration(ItemStack stack) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.isEdible()) {
            if (player.canEat(heldStack.getFoodProperties((LivingEntity)player).canAlwaysEat())) {
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)heldStack);
            }
            return InteractionResultHolder.fail((Object)heldStack);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        this.makePotionEffectsInfinite(entity);
        return super.finishUsingItem(stack, world, entity);
    }

    public void makePotionEffectsInfinite(LivingEntity player) {
        Collection effects = player.getActiveEffects();
        for (MobEffectInstance effect : effects) {
            player.addEffect(new MobEffectInstance(effect.getEffect(), Integer.MAX_VALUE, effect.getAmplifier(), effect.isAmbient(), effect.isVisible()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (this.hasCustomTooltip) {
            MutableComponent textEmpty = TextUtils.getTranslation("tooltip." + this, new Object[0]);
            tooltip.add((Component)textEmpty.withStyle(ChatFormatting.GOLD));
        }
        if (this.hasFoodEffectTooltip) {
            TextUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
        }
    }
}

