/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.entity;

import com.fruitstack.fruitstack.common.registry.ModEntityTypes;
import com.fruitstack.fruitstack.common.registry.ModItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RawMoonCakeEntity
extends ThrowableItemProjectile {
    public RawMoonCakeEntity(EntityType<? extends RawMoonCakeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public RawMoonCakeEntity(Level level, LivingEntity entity) {
        super((EntityType)ModEntityTypes.RAW_BLUEBERRIES_MOON_CAKE.get(), entity, level);
    }

    public RawMoonCakeEntity(Level level, double x, double y, double z) {
        super((EntityType)ModEntityTypes.RAW_BLUEBERRIES_MOON_CAKE.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.RAW_HAMIMELON_MOON_CAKE.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.getDefaultItem());
        if (id == 3) {
            ItemParticleOption iparticledata = new ItemParticleOption(ParticleTypes.ITEM, entityStack);
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)iparticledata, this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f + (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        this.playSound(SoundEvents.SNOW_BREAK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.SNOW_BREAK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.discard();
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

