/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.crafting.ingredient;

import com.fruitstack.fruitstack.fruitstack;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ChanceResult {
    public static final ChanceResult EMPTY = new ChanceResult(ItemStack.EMPTY, 1.0f);
    private final ItemStack stack;
    private final float chance;

    public ChanceResult(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack rollOutput(RandomSource rand, int fortuneLevel) {
        int outputAmount = this.stack.getCount();
        for (int roll = 0; roll < this.stack.getCount(); ++roll) {
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack out = this.stack.copy();
        out.setCount(outputAmount);
        return out;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)this.stack.getItem());
        json.addProperty("item", resourceLocation.toString());
        int count = this.stack.getCount();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.hasTag()) {
            json.add("nbt", new JsonParser().parse(this.stack.getTag().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ChanceResult deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = GsonHelper.getAsString((JsonObject)json, (String)"item");
        int count = GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1);
        float chance = GsonHelper.getAsFloat((JsonObject)json, (String)"chance", (float)1.0f);
        ItemStack itemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
        if (GsonHelper.isValidPrimitive((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.setTag(TagParser.parseTag((String)(element.isJsonObject() ? fruitstack.GSON.toJson(element) : GsonHelper.convertToString((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ChanceResult(itemstack, chance);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeItem(this.getStack());
        buf.writeFloat(this.getChance());
    }

    public static ChanceResult read(FriendlyByteBuf buf) {
        return new ChanceResult(buf.readItem(), buf.readFloat());
    }
}

