/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.crafting;

import com.fruitstack.fruitstack.common.block.entity.TvfmpoitBlockEntity;
import com.fruitstack.fruitstack.common.registry.ModItems;
import com.fruitstack.fruitstack.common.registry.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FoodServingRecipe
extends CustomRecipe {
    public FoodServingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack tripodVesselForMakingPillsOfImmortalityStack = ItemStack.EMPTY;
        ItemStack containerStack = ItemStack.EMPTY;
        ItemStack secondStack = ItemStack.EMPTY;
        for (int index = 0; index < container.getContainerSize(); ++index) {
            ItemStack mealStack;
            ItemStack selectedStack = container.getItem(index);
            if (selectedStack.isEmpty()) continue;
            if (tripodVesselForMakingPillsOfImmortalityStack.isEmpty() && !(mealStack = TvfmpoitBlockEntity.getMealFromItem(selectedStack)).isEmpty()) {
                tripodVesselForMakingPillsOfImmortalityStack = selectedStack;
                containerStack = TvfmpoitBlockEntity.getContainerFromItem(selectedStack);
                continue;
            }
            if (secondStack.isEmpty()) {
                secondStack = selectedStack;
                continue;
            }
            return false;
        }
        return !tripodVesselForMakingPillsOfImmortalityStack.isEmpty() && !secondStack.isEmpty() && secondStack.is(containerStack.getItem());
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack selectedStack = container.getItem(i);
            if (selectedStack.isEmpty() || !selectedStack.is((Item)ModItems.TRIPOD_VESSEL_FOR_MAKING_PILLS_OF_IMMORTALITY.get())) continue;
            ItemStack resultStack = TvfmpoitBlockEntity.getMealFromItem(selectedStack).copy();
            resultStack.setCount(1);
            return resultStack;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remainders = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remainders.size(); ++i) {
            ItemStack selectedStack = container.getItem(i);
            if (selectedStack.hasCraftingRemainingItem()) {
                remainders.set(i, (Object)selectedStack.getCraftingRemainingItem());
                continue;
            }
            if (!selectedStack.is((Item)ModItems.TRIPOD_VESSEL_FOR_MAKING_PILLS_OF_IMMORTALITY.get())) continue;
            TvfmpoitBlockEntity.takeServingFromItem(selectedStack);
            ItemStack newTripodVesselForMakingPillsOfImmortalityStack = selectedStack.copy();
            newTripodVesselForMakingPillsOfImmortalityStack.setCount(1);
            remainders.set(i, (Object)newTripodVesselForMakingPillsOfImmortalityStack);
            break;
        }
        return remainders;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.FOOD_SERVING.get();
    }
}

