/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block.entity.container;

import com.fruitstack.fruitstack.common.block.entity.JuicerBlockEntity;
import com.fruitstack.fruitstack.common.block.entity.container.JuicerBlockResultSlot;
import com.fruitstack.fruitstack.common.block.entity.container.JuicerMealSlot;
import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.fruitstack.fruitstack.common.registry.ModMenuTypes;
import com.fruitstack.fruitstack.fruitstack;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class JuicerBlockMenu
extends RecipeBookMenu<RecipeWrapper> {
    public final JuicerBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData tripodVesselForMakingPillsOfImmortalityData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public JuicerBlockMenu(int windowId, Inventory playerInventory, JuicerBlockEntity tileEntity, ContainerData tripodVesselForMakingPillsOfImmortalityDataIn) {
        super((MenuType)ModMenuTypes.JUICER.get(), windowId);
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.tripodVesselForMakingPillsOfImmortalityData = tripodVesselForMakingPillsOfImmortalityDataIn;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        int startX = 8;
        int startY = 18;
        int inputStartX = 30;
        int inputStartY = 26;
        int borderSlotSize = 18;
        for (int column = 0; column < 3; ++column) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, column, inputStartX + column * borderSlotSize, inputStartY));
        }
        this.addSlot((Slot)new JuicerMealSlot((IItemHandler)this.inventory, 3, 124, 26));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 4, 92, 55));
        this.addSlot((Slot)new JuicerBlockResultSlot(playerInventory.player, tileEntity, (IItemHandler)this.inventory, 5, 124, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column, startX + column * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.addDataSlots(tripodVesselForMakingPillsOfImmortalityDataIn);
    }

    private static JuicerBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof JuicerBlockEntity) {
            return (JuicerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public JuicerBlockMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, JuicerBlockMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean stillValid(Player playerIn) {
        return JuicerBlockMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)ModBlocks.JUICER.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int indexMealDisplay = 3;
        int indexContainerInput = 4;
        int indexOutput = 5;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == indexOutput) {
                if (!this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index > indexOutput) {
                if (itemstack1.getItem() == Items.BOWL && !this.moveItemStackTo(itemstack1, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(itemstack1, 0, indexMealDisplay, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(itemstack1, indexContainerInput, indexOutput, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.tripodVesselForMakingPillsOfImmortalityData.get(0);
        int j = this.tripodVesselForMakingPillsOfImmortalityData.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.tileEntity.isHeated();
    }

    public void fillCraftSlotsStackedContents(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.accountSimpleStack(this.inventory.getStackInSlot(i));
        }
    }

    public void clearCraftingContent() {
        for (int i = 0; i < 3; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public boolean recipeMatches(Recipe<? super RecipeWrapper> recipe) {
        return recipe.matches((Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.level);
    }

    public int getResultSlotIndex() {
        return 4;
    }

    public int getGridWidth() {
        return 4;
    }

    public int getGridHeight() {
        return 2;
    }

    public int getSize() {
        return 4;
    }

    public RecipeBookType getRecipeBookType() {
        return fruitstack.RECIPE_TYPE_COOKING;
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot < this.getGridWidth() * this.getGridHeight();
    }
}

