/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.fruitstack.fruitstack.common.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WineBarrelBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)3);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public WineBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCannItem(BlockState state) {
        return new ItemStack((ItemLike)ModItems.CANN.get());
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack cann = this.getCannItem(state);
        int sugar = (Integer)state.getValue((Property)STAGE);
        if (!level.isClientSide) {
            if (sugar == 0 && heldStack.getItem() == Items.SUGAR && heldStack.getCount() >= 3) {
                heldStack.shrink(3);
                level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(1)), 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 0 && heldStack.getItem() == Items.WHEAT && heldStack.getCount() >= 5) {
                heldStack.shrink(5);
                level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(3)), 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 1 && heldStack.getItem() == ModItems.CHINESE_SPIRITS_TEN.get() && heldStack.getCount() >= 1) {
                heldStack.shrink(1);
                if (!player.getInventory().add(cann)) {
                    player.drop(cann, false);
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(2)), 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 3 && heldStack.getItem() == ModItems.GLUTINOUS_RICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.CHINESE_SPIRITS_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && (heldStack.getItem() == ModItems.MANGO_SLICE.get() || heldStack.getItem() == ModItems.GREEN_MANGO_SLICE.get()) && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.MANGO_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.BLUEBERRIES.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.BLUEBERRIES_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.HAMIMELON.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.HAMIMELON_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.HOLBOELLIA_LATIFOLIA_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.HOLBOELLIA_LATIFOLIA_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.LITCHI_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.LITCHI_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.HUOSHEN_FRUIT_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.HUOSHEN_FRUIT_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.BEATING_MELONS_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.BEATING_MELONS_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.GROUND_CUCUMBER_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.GROUND_CUCUMBER_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.SEPTEMBER_MELON.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.SEPTEMBER_MELON_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.PITAYA_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.PITAYA_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.GOLDEN_PURE_SHEEP_HORN_HONEY_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.GOLDEN_PURE_SHEEP_HORN_HONEY_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.PEAR_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.PEAR_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.MAYTHORN.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.MAYTHORN_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.CHINESE_PEAR_LEAVED_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.CHINESE_PEAR_LEAVED_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.PLUM.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.PLUM_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.JUJUBE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.JUJUBE_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.APRICOT.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.APRICOT_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.RED_BAYBERRY.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.RED_BAYBERRY_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.GREEN_PLUM.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.GREEN_PLUM_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.CRUSHED_GRAPES.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.GRAPE_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (sugar == 2 && heldStack.getItem() == ModItems.PEACH_SLICE.get() && heldStack.getCount() >= 8) {
                heldStack.shrink(8);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
                BlockState originalState = level.getBlockState(pos);
                Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockState newState = ((Block)ModBlocks.PEACH_WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
                level.setBlock(pos, newState, 3);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }
}

