/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.block.entity.TvfmpoitBlockEntity;
import com.fruitstack.fruitstack.common.block.state.TvfmpoiSupport;
import com.fruitstack.fruitstack.common.registry.ModBlockEntityTypes;
import com.fruitstack.fruitstack.common.registry.ModSounds;
import com.fruitstack.fruitstack.common.tag.ModTags;
import com.fruitstack.fruitstack.common.utility.MathUtils;
import com.fruitstack.fruitstack.common.utility.TextUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class TvfmpoiBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<TvfmpoiSupport> SUPPORT = EnumProperty.create((String)"support", TvfmpoiSupport.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public TvfmpoiBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(0.5f, 6.0f).sound(SoundType.LANTERN));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SUPPORT, (Comparable)((Object)TvfmpoiSupport.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.isEmpty() && player.isShiftKeyDown()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(SUPPORT, (Comparable)((Object)(((TvfmpoiSupport)((Object)state.getValue(SUPPORT))).equals((Object)TvfmpoiSupport.HANDLE) ? this.getTrayState((LevelAccessor)level, pos) : TvfmpoiSupport.HANDLE))));
            level.playSound(null, pos, SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 0.7f, 1.0f);
        } else if (!level.isClientSide) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof TvfmpoitBlockEntity) {
                TvfmpoitBlockEntity tvfmpoitBlockEntity = (TvfmpoitBlockEntity)tileEntity;
                ItemStack servingStack = tvfmpoitBlockEntity.useHeldItemOnMeal(heldStack);
                if (servingStack != ItemStack.EMPTY) {
                    if (!player.getInventory().add(servingStack)) {
                        player.drop(servingStack, false);
                    }
                    level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)tvfmpoitBlockEntity, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((TvfmpoiSupport)((Object)state.getValue(SUPPORT))).equals((Object)TvfmpoiSupport.TRAY) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluid = level.getFluidState(context.getClickedPos());
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        if (context.getClickedFace().equals((Object)Direction.DOWN)) {
            return (BlockState)state.setValue(SUPPORT, (Comparable)((Object)TvfmpoiSupport.HANDLE));
        }
        return (BlockState)state.setValue(SUPPORT, (Comparable)((Object)this.getTrayState((LevelAccessor)level, pos)));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facing.getAxis().equals((Object)Direction.Axis.Y) && !((TvfmpoiSupport)((Object)state.getValue(SUPPORT))).equals((Object)TvfmpoiSupport.HANDLE)) {
            return (BlockState)state.setValue(SUPPORT, (Comparable)((Object)this.getTrayState(level, currentPos)));
        }
        return state;
    }

    private TvfmpoiSupport getTrayState(LevelAccessor level, BlockPos pos) {
        if (level.getBlockState(pos.below()).is(ModTags.TRAY_HEAT_SOURCES)) {
            return TvfmpoiSupport.TRAY;
        }
        return TvfmpoiSupport.NONE;
    }

    public ItemStack getCloneItemStack(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        TvfmpoitBlockEntity tripodVesselForMakingPillsOfImmortalityEntity = (TvfmpoitBlockEntity)level.getBlockEntity(pos);
        if (tripodVesselForMakingPillsOfImmortalityEntity != null) {
            CompoundTag nbt = tripodVesselForMakingPillsOfImmortalityEntity.writeMeal(new CompoundTag());
            if (!nbt.isEmpty()) {
                stack.addTagElement("BlockEntityTag", (Tag)nbt);
            }
            if (tripodVesselForMakingPillsOfImmortalityEntity.hasCustomName()) {
                stack.setHoverName(tripodVesselForMakingPillsOfImmortalityEntity.getCustomName());
            }
        }
        return stack;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof TvfmpoitBlockEntity) {
                TvfmpoitBlockEntity tripodVesselForMakingPillsOfImmortalityEntity = (TvfmpoitBlockEntity)tileEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, tripodVesselForMakingPillsOfImmortalityEntity.getDroppableInventory());
                tripodVesselForMakingPillsOfImmortalityEntity.getUsedRecipesAndPopExperience(level, Vec3.atCenterOf((Vec3i)pos));
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, level, tooltip, flagIn);
        CompoundTag nbt = stack.getTagElement("BlockEntityTag");
        ItemStack mealStack = TvfmpoitBlockEntity.getMealFromItem(stack);
        if (!mealStack.isEmpty()) {
            MutableComponent textServingsOf = mealStack.getCount() == 1 ? TextUtils.getTranslation("tooltip.tripod_vessel_for_making_pills_of_immortality.single_serving", new Object[0]) : TextUtils.getTranslation("tooltip.tripod_vessel_for_making_pills_of_immortality.many_servings", mealStack.getCount());
            tooltip.add((Component)textServingsOf.withStyle(ChatFormatting.GRAY));
            MutableComponent textMealName = mealStack.getHoverName().copy();
            tooltip.add((Component)textMealName.withStyle(mealStack.getRarity().color));
        } else {
            MutableComponent textEmpty = TextUtils.getTranslation("tooltip.tripod_vessel_for_making_pills_of_immortality.empty", new Object[0]);
            tooltip.add((Component)textEmpty.withStyle(ChatFormatting.GRAY));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SUPPORT, WATERLOGGED});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity;
        if (stack.hasCustomHoverName() && (tileEntity = level.getBlockEntity(pos)) instanceof TvfmpoitBlockEntity) {
            ((TvfmpoitBlockEntity)tileEntity).setCustomName(stack.getHoverName());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        TvfmpoitBlockEntity tripodVesselForMakingPillsOfImmortalityEntity;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof TvfmpoitBlockEntity && (tripodVesselForMakingPillsOfImmortalityEntity = (TvfmpoitBlockEntity)tileEntity).isHeated()) {
            SoundEvent boilSound = !tripodVesselForMakingPillsOfImmortalityEntity.getMeal().isEmpty() ? (SoundEvent)ModSounds.BLOCK_TVFMPOIT_BOIL_SOUP.get() : (SoundEvent)ModSounds.BLOCK_TVFMPOIT_BOIL.get();
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (rand.nextInt(10) == 0) {
                level.playLocalSound(x, y, z, boilSound, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof TvfmpoitBlockEntity) {
            ItemStackHandler inventory = ((TvfmpoitBlockEntity)tileEntity).getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.TRIPOD_VESSEL_FOR_MAKING_PILLS_OF_IMMORTALITY.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return TvfmpoiBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.TRIPOD_VESSEL_FOR_MAKING_PILLS_OF_IMMORTALITY.get()), TvfmpoitBlockEntity::animationTick);
        }
        return TvfmpoiBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.TRIPOD_VESSEL_FOR_MAKING_PILLS_OF_IMMORTALITY.get()), TvfmpoitBlockEntity::cookingTick);
    }
}

