/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.block.state.PizzaStage;
import com.fruitstack.fruitstack.common.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PizzaBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<PizzaStage> STAGE = EnumProperty.create((String)"stage", PizzaStage.class);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);

    public PizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STAGE, (Comparable)((Object)PizzaStage.DOUGH_STAGE0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
        super.createBlockStateDefinition(builder);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.pizza(level, pos, state, player, hand, hit).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.pizza(level, pos, state, player, hand, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public InteractionResult pizza(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItem() == ModItems.ROLLING_PIN.get() && state.getValue(STAGE) == PizzaStage.DOUGH_STAGE0) {
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.DOUGH_STAGE1)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.ROLLING_PIN.get() && state.getValue(STAGE) == PizzaStage.DOUGH_STAGE1) {
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.DOUGH_STAGE2)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == Items.APPLE && state.getValue(STAGE) == PizzaStage.DOUGH_STAGE2) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_GRAPE_FRUIT_SAND_PIZZA_STAGE0)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.CHINESE_PEAR_LEAVED_SLICE.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_GRAPE_FRUIT_SAND_PIZZA_STAGE0) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_GRAPE_FRUIT_SAND_PIZZA_STAGE1)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.GRAPE.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_GRAPE_FRUIT_SAND_PIZZA_STAGE1) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_GRAPE_FRUIT_SAND_PIZZA_STAGE2)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == PizzaStage.UNBAKED_GRAPE_FRUIT_SAND_PIZZA_STAGE2) {
            level.removeBlock(pos, false);
            if (!player.getInventory().add(((Item)ModItems.UNBAKED_GRAPE_FRUIT_SAND_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.UNBAKED_GRAPE_FRUIT_SAND_PIZZA.get()).getDefaultInstance(), false);
            }
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.BLUEBERRIES.get() && state.getValue(STAGE) == PizzaStage.DOUGH_STAGE2) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_BLUE_RED_MANGO_PIZZA_STAGE0)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.MANGO_SLICE.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_BLUE_RED_MANGO_PIZZA_STAGE0) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_BLUE_RED_MANGO_PIZZA_STAGE1)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.PITAYA_SLICE.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_BLUE_RED_MANGO_PIZZA_STAGE1) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_BLUE_RED_MANGO_PIZZA_STAGE2)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == PizzaStage.UNBAKED_BLUE_RED_MANGO_PIZZA_STAGE2) {
            level.removeBlock(pos, false);
            if (!player.getInventory().add(((Item)ModItems.UNBAKED_BLUE_RED_MANGO_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.UNBAKED_BLUE_RED_MANGO_PIZZA.get()).getDefaultInstance(), false);
            }
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.MAYTHORN.get() && state.getValue(STAGE) == PizzaStage.DOUGH_STAGE2) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_HAWTHORN_NUT_PIZZA_STAGE0)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.JUJUBE.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_HAWTHORN_NUT_PIZZA_STAGE0) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_HAWTHORN_NUT_PIZZA_STAGE1)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.APRICOT.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_HAWTHORN_NUT_PIZZA_STAGE1) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_HAWTHORN_NUT_PIZZA_STAGE2)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == PizzaStage.UNBAKED_HAWTHORN_NUT_PIZZA_STAGE2) {
            level.removeBlock(pos, false);
            if (!player.getInventory().add(((Item)ModItems.UNBAKED_HAWTHORN_NUT_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.UNBAKED_HAWTHORN_NUT_PIZZA.get()).getDefaultInstance(), false);
            }
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.RED_BAYBERRY.get() && state.getValue(STAGE) == PizzaStage.DOUGH_STAGE2) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA_STAGE0)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.GREEN_PLUM.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA_STAGE0) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA_STAGE1)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.PLUM.get() && state.getValue(STAGE) == PizzaStage.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA_STAGE1) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)PizzaStage.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA_STAGE2)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == PizzaStage.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA_STAGE2) {
            level.removeBlock(pos, false);
            if (!player.getInventory().add(((Item)ModItems.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA.get()).getDefaultInstance(), false);
            }
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }
}

