/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.block.state.OvenStage;
import com.fruitstack.fruitstack.common.registry.ModItems;
import com.fruitstack.fruitstack.common.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OvenBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<OvenStage> STAGE = EnumProperty.create((String)"stage", OvenStage.class);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public OvenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STAGE, (Comparable)((Object)OvenStage.OVEN)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
        super.createBlockStateDefinition(builder);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.oven(level, pos, state, player, hand, hit).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.oven(level, pos, state, player, hand, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public InteractionResult oven(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItem() == ModItems.UNBAKED_GRAPE_FRUIT_SAND_PIZZA.get() && state.getValue(STAGE) == OvenStage.OVEN) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_UNBAKED_GRAPE_FRUIT_SAND_PIZZA)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == OvenStage.OVEN_WITH_GRAPE_FRUIT_SAND_PIZZA) {
            if (!player.getInventory().add(((Item)ModItems.GRAPE_FRUIT_SAND_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.GRAPE_FRUIT_SAND_PIZZA.get()).getDefaultInstance(), false);
            }
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN)), 3);
            level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_OVEN_DING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.UNBAKED_BLUE_RED_MANGO_PIZZA.get() && state.getValue(STAGE) == OvenStage.OVEN) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_UNBAKED_BLUE_RED_MANGO_PIZZA)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == OvenStage.OVEN_WITH_BLUE_RED_MANGO_PIZZA) {
            if (!player.getInventory().add(((Item)ModItems.BLUE_RED_MANGO_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.BLUE_RED_MANGO_PIZZA.get()).getDefaultInstance(), false);
            }
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN)), 3);
            level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_OVEN_DING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.UNBAKED_HAWTHORN_NUT_PIZZA.get() && state.getValue(STAGE) == OvenStage.OVEN) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_UNBAKED_HAWTHORN_NUT_PIZZA)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == OvenStage.OVEN_WITH_HAWTHORN_NUT_PIZZA) {
            if (!player.getInventory().add(((Item)ModItems.HAWTHORN_NUT_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.HAWTHORN_NUT_PIZZA.get()).getDefaultInstance(), false);
            }
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN)), 3);
            level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_OVEN_DING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.getItem() == ModItems.UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA.get() && state.getValue(STAGE) == OvenStage.OVEN) {
            heldStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(STAGE) == OvenStage.OVEN_WITH_SWEET_AND_REFRESHING_FLAVORED_PIZZA) {
            if (!player.getInventory().add(((Item)ModItems.SWEET_AND_REFRESHING_FLAVORED_PIZZA.get()).getDefaultInstance())) {
                player.drop(((Item)ModItems.SWEET_AND_REFRESHING_FLAVORED_PIZZA.get()).getDefaultInstance(), false);
            }
            level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN)), 3);
            level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_OVEN_DING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isClientSide) {
            boolean isHeated = this.isHeated((Level)worldIn, pos);
            if (random.nextFloat() <= 0.1f && isHeated) {
                if (state.getValue(STAGE) == OvenStage.OVEN_WITH_UNBAKED_GRAPE_FRUIT_SAND_PIZZA) {
                    worldIn.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_GRAPE_FRUIT_SAND_PIZZA)), 3);
                }
                if (state.getValue(STAGE) == OvenStage.OVEN_WITH_UNBAKED_BLUE_RED_MANGO_PIZZA) {
                    worldIn.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_BLUE_RED_MANGO_PIZZA)), 3);
                }
                if (state.getValue(STAGE) == OvenStage.OVEN_WITH_UNBAKED_HAWTHORN_NUT_PIZZA) {
                    worldIn.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_HAWTHORN_NUT_PIZZA)), 3);
                }
                if (state.getValue(STAGE) == OvenStage.OVEN_WITH_UNBAKED_SWEET_AND_REFRESHING_FLAVORED_PIZZA) {
                    worldIn.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)OvenStage.OVEN_WITH_SWEET_AND_REFRESHING_FLAVORED_PIZZA)), 3);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        boolean isHeated = this.isHeated(level, pos);
        if (isHeated) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            if (rand.nextInt(8) == 0 && !((OvenStage)((Object)state.getValue(STAGE))).equals((Object)OvenStage.OVEN)) {
                level.playLocalSound(x, y, z, (SoundEvent)ModSounds.BLOCK_OVEN_BAKE.get(), SoundSource.BLOCKS, 0.4f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    boolean isHeated(Level level, BlockPos pos) {
        return this.isDaytime(level) && !level.isRaining() && level.canSeeSky(pos) && level.canSeeSky(pos);
    }

    private boolean isDaytime(Level world) {
        long timeOfDay = world.getDayTime() % 24000L;
        return timeOfDay >= 0L && timeOfDay < 12000L;
    }
}

