/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.registry.ModItems;
import com.fruitstack.fruitstack.common.tag.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LitchiRiverDough
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0);

    public LitchiRiverDough(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.takeDried((LevelAccessor)level, pos, state, player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.takeDried((LevelAccessor)level, pos, state, player, hand);
    }

    protected InteractionResult takeDried(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.LITCHI_RIVER_DOUGH.get());
        ItemStack itemStackTwo = new ItemStack((ItemLike)ModItems.LITCHI_RIVER_NOODLES.get());
        if (heldStack.isEmpty()) {
            level.removeBlock(pos, false);
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), itemStack);
            level.addFreshEntity((Entity)itemEntity);
        }
        if (heldStack.is(ModTags.FRUIT_KNIVES)) {
            level.removeBlock(pos, false);
            ItemEntity itemEntityTwo = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), itemStackTwo);
            level.addFreshEntity((Entity)itemEntityTwo);
        }
        level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }
}

