/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.fruitstack.fruitstack.common.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapeCropBlock
extends Block {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)7);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private final Supplier<Block> grapeother;
    public final Supplier<Item> grapeItem;

    public GrapeCropBlock(Supplier<Block> grapeother, BlockBehaviour.Properties properties, Supplier<Item> grapeItem) {
        super(properties);
        this.grapeItem = grapeItem;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.grapeother = grapeother;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getGrapeItem(BlockState state) {
        return new ItemStack((ItemLike)this.grapeItem.get());
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, facingState, level, pos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isClientSide && rand.nextFloat() <= 0.1f) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age == 0) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            } else if (age < 7) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            }
            if (this.hasGrapeCropTopOutsideRange((Level)worldIn, pos, 6)) {
                return;
            }
            if (worldIn.getBlockState(pos.north()).is((Block)ModBlocks.GRAPE_BRACKET.get())) {
                worldIn.setBlock(pos.north(), this.grapeother.get().defaultBlockState(), 3);
            } else if (worldIn.getBlockState(pos.south()).is((Block)ModBlocks.GRAPE_BRACKET.get())) {
                worldIn.setBlock(pos.south(), this.grapeother.get().defaultBlockState(), 3);
            } else if (worldIn.getBlockState(pos.west()).is((Block)ModBlocks.GRAPE_BRACKET.get())) {
                worldIn.setBlock(pos.west(), this.grapeother.get().defaultBlockState(), 3);
            } else if (worldIn.getBlockState(pos.east()).is((Block)ModBlocks.GRAPE_BRACKET.get())) {
                worldIn.setBlock(pos.east(), this.grapeother.get().defaultBlockState(), 3);
            }
        }
    }

    private boolean hasGrapeCropTopOutsideRange(Level world, BlockPos pos, int range) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    mutablePos.setWithOffset((Vec3i)pos, x, y, z);
                    if (Math.abs(x) <= range - 1 && Math.abs(y) <= range - 1 && Math.abs(z) <= range - 1 || !world.getBlockState((BlockPos)mutablePos).is((Block)ModBlocks.GRAPE_CROP_TOP.get())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.boneMeal((LevelAccessor)level, pos, state, player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.boneMeal((LevelAccessor)level, pos, state, player, hand);
    }

    protected InteractionResult boneMeal(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int age = (Integer)state.getValue((Property)AGE);
        ItemStack grape = this.getGrapeItem(state);
        ItemStack heldStack = player.getItemInHand(hand);
        if (age == 0 && heldStack.getItem() == Items.BONE_MEAL) {
            level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            heldStack.shrink(1);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            return InteractionResult.SUCCESS;
        }
        if (age < 7 && heldStack.getItem() == Items.BONE_MEAL) {
            level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            heldStack.shrink(1);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            return InteractionResult.SUCCESS;
        }
        if (age == 7 && heldStack.isEmpty()) {
            level.playSound(null, pos, SoundEvents.CROP_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.GRAPE.get());
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5, itemStack);
            level.addFreshEntity((Entity)itemEntity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

