/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.block.state.FryingPanStage;
import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.fruitstack.fruitstack.common.registry.ModDamageTypes;
import com.fruitstack.fruitstack.common.registry.ModItems;
import com.fruitstack.fruitstack.common.registry.ModParticleTypes;
import com.fruitstack.fruitstack.common.registry.ModSounds;
import com.fruitstack.fruitstack.common.utility.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FryingPanBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<FryingPanStage> STAGE = EnumProperty.create((String)"stage", FryingPanStage.class);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);

    public FryingPanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STAGE, (Comparable)((Object)FryingPanStage.NONE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
        super.createBlockStateDefinition(builder);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.fryingPan(level, pos, state, player, hand, hit).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.fryingPan(level, pos, state, player, hand, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public InteractionResult fryingPan(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.getItemInHand(hand);
        boolean isHeated = this.isHeated(level, pos);
        boolean isice = this.isice(level, pos);
        ItemStack sunflower_oil = ((Item)ModItems.SUNFLOWER_OIL.get()).getDefaultInstance();
        ItemStack pot_cover = ((Item)ModItems.POT_COVER.get()).getDefaultInstance();
        ItemStack bowl = Items.BOWL.getDefaultInstance();
        if (isHeated) {
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.NONE)) {
                if (heldStack.getItem() == ModItems.SUNFLOWER_OIL.get()) {
                    heldStack.shrink(1);
                    if (!player.getInventory().add(Items.BOWL.getDefaultInstance())) {
                        player.drop(Items.BOWL.getDefaultInstance(), false);
                    }
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.SUNFLOWER_OIL)), 3);
                    level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_OIL_SIZZLE.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                } else {
                    if (heldStack.getItem() == Items.SUGAR) {
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                        heldStack.shrink(1);
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_SUGAR_AGE0)), 3);
                        return InteractionResult.SUCCESS;
                    }
                    player.displayClientMessage((Component)TextUtils.getTranslation("block.frying_pan.sunflower_oil", sunflower_oil.getCraftingRemainingItem().getHoverName()), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FIRE)) {
                if (heldStack.getItem() == ModItems.POT_COVER.get()) {
                    heldStack.shrink(1);
                    level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.POT_COVER)), 3);
                } else {
                    player.displayClientMessage((Component)TextUtils.getTranslation("block.frying_pan.pot_cover", pot_cover.getCraftingRemainingItem().getHoverName()), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.POT_COVER)) {
                if (heldStack.getItem() == Items.BOWL) {
                    heldStack.shrink(1);
                    if (!player.getInventory().add(((Item)ModItems.THE_BURNT_DISH.get()).getDefaultInstance())) {
                        player.drop(((Item)ModItems.THE_BURNT_DISH.get()).getDefaultInstance(), false);
                    }
                    if (!player.getInventory().add(((Item)ModItems.POT_COVER.get()).getDefaultInstance())) {
                        player.drop(((Item)ModItems.POT_COVER.get()).getDefaultInstance(), false);
                    }
                    level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.NONE)), 3);
                } else {
                    player.displayClientMessage((Component)TextUtils.getTranslation("block.frying_pan.bowl", bowl.getCraftingRemainingItem().getHoverName()), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.SUNFLOWER_OIL)) {
                if (heldStack.getItem() == ModItems.BEATING_MELONS_SEEDS.get()) {
                    level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    heldStack.shrink(1);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_BEATING_MELONS_SEEDS_AGE0)), 3);
                }
                if (heldStack.getItem() == ModItems.LITCHI_BALL.get()) {
                    level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    heldStack.shrink(1);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_CRISPY_LITCHI_BALL_AGE0)), 3);
                }
                if (heldStack.getItem() == ModItems.UNFINISHED_HONEY_MELON_CHICKEN_BALLS.get()) {
                    level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    heldStack.shrink(1);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_UNFINISHED_HONEY_MELON_CHICKEN_BALLS_AGE0)), 3);
                }
                return InteractionResult.SUCCESS;
            }
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_SUGAR_AGE1)) {
                if (heldStack.getItem() == ModItems.BLACK_TEA_LEAVES_ITEM.get()) {
                    level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    heldStack.shrink(1);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_BLACK_TEA_AGE0)), 3);
                }
                return InteractionResult.SUCCESS;
            }
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_BLACK_TEA_AGE1)) {
                if (heldStack.getItem() == Items.MILK_BUCKET) {
                    level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    heldStack.shrink(1);
                    if (!player.getInventory().add(Items.BUCKET.getDefaultInstance())) {
                        player.drop(Items.BUCKET.getDefaultInstance(), false);
                    }
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_MILK_AGE0)), 3);
                }
                return InteractionResult.SUCCESS;
            }
            if (heldStack.getItem() == ModItems.SPATULA.get()) {
                RandomSource random = level.random;
                if (random.nextFloat() < 0.1f) {
                    if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_BEATING_MELONS_SEEDS_AGE0)) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_BEATING_MELONS_SEEDS_AGE1)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (state.getValue(STAGE) == FryingPanStage.FRYING_PAN_STIR_FRIED_BEATING_MELONS_SEEDS_AGE1) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_BEATING_MELONS_SEEDS_AGE2)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_CRISPY_LITCHI_BALL_AGE0)) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_CRISPY_LITCHI_BALL_AGE1)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (state.getValue(STAGE) == FryingPanStage.FRYING_PAN_CRISPY_LITCHI_BALL_AGE1) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_CRISPY_LITCHI_BALL_AGE2)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_UNFINISHED_HONEY_MELON_CHICKEN_BALLS_AGE0)) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_UNFINISHED_HONEY_MELON_CHICKEN_BALLS_AGE1)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (state.getValue(STAGE) == FryingPanStage.FRYING_PAN_UNFINISHED_HONEY_MELON_CHICKEN_BALLS_AGE1) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_UNFINISHED_HONEY_MELON_CHICKEN_BALLS_AGE2)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_SUGAR_AGE0)) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_SUGAR_AGE1)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (state.getValue(STAGE) == FryingPanStage.FRYING_PAN_MILKY_TEA_BLACK_TEA_AGE0) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_BLACK_TEA_AGE1)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_MILK_AGE0)) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_MILK_AGE1)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_BEATING_MELONS_SEEDS_AGE2)) {
                if (!player.getInventory().add(((Item)ModItems.STIR_FRIED_BEATING_MELONS_SEEDS.get()).getDefaultInstance())) {
                    player.drop(((Item)ModItems.STIR_FRIED_BEATING_MELONS_SEEDS.get()).getDefaultInstance(), false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.NONE)), 3);
                return InteractionResult.SUCCESS;
            }
            if (heldStack.getItem() == Items.BOWL) {
                if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_CRISPY_LITCHI_BALL_AGE2)) {
                    heldStack.shrink(1);
                    if (!player.getInventory().add(((Item)ModItems.CRISPY_LITCHI_BALL.get()).getDefaultInstance())) {
                        player.drop(((Item)ModItems.CRISPY_LITCHI_BALL.get()).getDefaultInstance(), false);
                    }
                    level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.NONE)), 3);
                }
                if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_UNFINISHED_HONEY_MELON_CHICKEN_BALLS_AGE2)) {
                    heldStack.shrink(1);
                    if (!player.getInventory().add(((Item)ModItems.HONEY_MELON_CHICKEN_BALLS.get()).getDefaultInstance())) {
                        player.drop(((Item)ModItems.HONEY_MELON_CHICKEN_BALLS.get()).getDefaultInstance(), false);
                    }
                    level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.NONE)), 3);
                }
                return InteractionResult.SUCCESS;
            }
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_MILKY_TEA_MILK_AGE1) && heldStack.getItem() == ModItems.MILK_TEA_CUP.get()) {
                heldStack.shrink(1);
                if (!player.getInventory().add(((Item)ModItems.MILKY_TEA.get()).getDefaultInstance())) {
                    player.drop(((Item)ModItems.MILKY_TEA.get()).getDefaultInstance(), false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.NONE)), 3);
                return InteractionResult.SUCCESS;
            }
        }
        if (isice) {
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.NONE)) {
                if (heldStack.getItem() == Items.MILK_BUCKET) {
                    heldStack.shrink(1);
                    if (!player.getInventory().add(Items.BUCKET.getDefaultInstance())) {
                        player.drop(Items.BUCKET.getDefaultInstance(), false);
                    }
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_YOGURT_AGE0)), 3);
                }
                return InteractionResult.SUCCESS;
            }
            if (heldStack.getItem() == ModItems.SPATULA.get()) {
                RandomSource random = level.random;
                if (random.nextFloat() < 0.1f) {
                    if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_YOGURT_AGE0)) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_YOGURT_AGE1)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    } else if (state.getValue(STAGE) == FryingPanStage.FRYING_PAN_STIR_FRIED_YOGURT_AGE1) {
                        level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_YOGURT_AGE2)), 3);
                        level.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SPATULA.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (heldStack.getItem() == Items.BOWL) {
                if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FRYING_PAN_STIR_FRIED_YOGURT_AGE2)) {
                    heldStack.shrink(1);
                    if (!player.getInventory().add(((Item)ModItems.STIR_FRIED_YOGURT.get()).getDefaultInstance())) {
                        player.drop(((Item)ModItems.STIR_FRIED_YOGURT.get()).getDefaultInstance(), false);
                    }
                    level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.NONE)), 3);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isClientSide) {
            if (random.nextFloat() <= 0.5f && ((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FIRE)) {
                BlockPos blockPos = pos.north();
                BlockState northBlockState = worldIn.getBlockState(blockPos);
                worldIn.setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
                blockPos = pos.south();
                BlockState southBlockState = worldIn.getBlockState(blockPos);
                worldIn.setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
                blockPos = pos.east();
                BlockState eastBlockState = worldIn.getBlockState(blockPos);
                worldIn.setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
                blockPos = pos.west();
                BlockState westBlockState = worldIn.getBlockState(blockPos);
                worldIn.setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
            }
            if (!(((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.NONE) || ((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FIRE) || ((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.POT_COVER) || ((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.SUNFLOWER_OIL) || !(random.nextFloat() <= 0.1f))) {
                worldIn.setBlock(pos, (BlockState)state.setValue(STAGE, (Comparable)((Object)FryingPanStage.FIRE)), 3);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double z;
        double y;
        double x;
        boolean isHeated = this.isHeated(level, pos);
        boolean isice = this.isice(level, pos);
        if (isHeated) {
            x = (double)pos.getX() + 0.5;
            y = (double)pos.getY() + 0.2;
            z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            if (((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.SUNFLOWER_OIL)) {
                level.addParticle((ParticleOptions)ModParticleTypes.OIL.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            if (rand.nextInt(10) == 0 && !((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.NONE)) {
                level.playLocalSound(x, y, z, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SIZZLE.get(), SoundSource.BLOCKS, 0.4f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
        if (isice) {
            x = (double)pos.getX() + 0.5;
            y = (double)pos.getY() + 0.2;
            z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, 0.0, 0.0, 0.0);
        }
        if (isHeated && ((FryingPanStage)((Object)state.getValue(STAGE))).equals((Object)FryingPanStage.FIRE)) {
            x = (double)pos.getX() + 0.5;
            y = (double)pos.getY() + 0.4;
            z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isHeated = this.isHeated(level, pos);
        if (isHeated && !entity.fireImmune() && entity instanceof LivingEntity && !EnchantmentHelper.hasFrostWalker((LivingEntity)((LivingEntity)entity))) {
            entity.hurt(ModDamageTypes.getSimpleDamageSource(level, ModDamageTypes.FRYING_PAN_BURN), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    boolean isHeated(Level level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.is((Block)ModBlocks.CLAY_OVEN.get());
    }

    boolean isice(Level level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.is(Blocks.BLUE_ICE);
    }
}

