/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.registry.ModBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FruitPopsicleMachineBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public final Supplier<Item> popsicleItem;

    public FruitPopsicleMachineBlock(BlockBehaviour.Properties properties, Supplier<Item> popsicleItem) {
        super(properties);
        this.popsicleItem = popsicleItem;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getPopsicleItem(BlockState state) {
        return new ItemStack((ItemLike)this.popsicleItem.get());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.mackPopsicle(level, pos, state, player, hand, hit).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.mackPopsicle(level, pos, state, player, hand, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult mackPopsicle(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        int age = (Integer)state.getValue((Property)AGE);
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack popsicle = this.getPopsicleItem(state);
        if (age == 0 && heldStack.getItem() == Items.STICK && heldStack.getCount() >= 6) {
            heldStack.shrink(6);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (age == 2) {
            for (int i = 0; i < 6; ++i) {
                if (player.getInventory().add(popsicle.copy())) continue;
                player.drop(popsicle.copy(), false);
            }
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
            BlockState originalState = level.getBlockState(pos);
            Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockState newState = ((Block)ModBlocks.POPSICLE_MACHINE.get()).getStateForPlacement(blockPlaceContext);
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
            level.setBlock(pos, newState, 3);
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE});
        super.createBlockStateDefinition(builder);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int age;
        if (!worldIn.isClientSide && this.isDaytime((Level)worldIn) && !worldIn.isRaining() && worldIn.canSeeSky(pos) && worldIn.canSeeSky(pos) && random.nextFloat() <= 0.1f && (age = ((Integer)state.getValue((Property)AGE)).intValue()) == 1) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 3);
            worldIn.updateNeighborsAt(pos, (Block)this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (this.isDaytime(level) && !level.isRaining() && level.canSeeSky(pos) && level.canSeeSky(pos)) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.6;
            double z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean isSignalSource(BlockState p_55213_) {
        return true;
    }

    public int getSignal(BlockState p_55208_, BlockGetter p_55209_, BlockPos p_55210_, Direction p_55211_) {
        int age = (Integer)p_55208_.getValue((Property)AGE);
        return age + 2;
    }

    private boolean isDaytime(Level world) {
        long timeOfDay = world.getDayTime() % 24000L;
        return timeOfDay >= 0L && timeOfDay < 12000L;
    }
}

