/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.utility.TextUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DriedFruit
extends Block {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
    public final Supplier<Item> driedItem;

    public DriedFruit(BlockBehaviour.Properties properties, Supplier<Item> driedItem) {
        super(properties);
        this.driedItem = driedItem;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getDriedItem(BlockState state) {
        return new ItemStack((ItemLike)this.driedItem.get());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.takeDried((LevelAccessor)level, pos, state, player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.takeDried((LevelAccessor)level, pos, state, player, hand);
    }

    protected InteractionResult takeDried(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int age = (Integer)state.getValue((Property)AGE);
        ItemStack dried = this.getDriedItem(state);
        if (age == 2) {
            level.removeBlock(pos, false);
            if (!player.getInventory().add(dried)) {
                player.drop(dried, false);
            }
            level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)TextUtils.getTranslation("block.dried.get", dried.getCraftingRemainingItem().getHoverName()), true);
        return InteractionResult.PASS;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, facingState, level, pos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (level.getBlockState(pos.below()).getBlock() == this) {
            return false;
        }
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isClientSide && this.isDaytime(worldIn) && !worldIn.isRaining() && rand.nextFloat() <= 0.1f) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age == 0) {
                if (worldIn.canSeeSky(pos)) {
                    worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
                }
            } else if (age == 1 && this.isDaytime(worldIn) && worldIn.canSeeSky(pos)) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 3);
            }
        }
        boolean hasBlockAbove = false;
        for (int y = pos.getY() + 1; y <= worldIn.getHeight(); ++y) {
            BlockPos checkPos = new BlockPos(pos.getX(), y, pos.getZ());
            if (worldIn.getBlockState(checkPos).isAir()) continue;
            hasBlockAbove = true;
            break;
        }
        if (!worldIn.isClientSide && worldIn.isRaining() && worldIn.canSeeSky(pos) && !hasBlockAbove) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    private boolean isDaytime(ServerLevel world) {
        long timeOfDay = world.getDayTime() % 24000L;
        return timeOfDay >= 0L && timeOfDay < 12000L;
    }
}

