/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.block.ModLeavesBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFruitCrop
extends Block
implements BonemealableBlock {
    private String name;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    public static boolean fruitRemoval = false;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public BlockFruitCrop(BlockBehaviour.Properties p_i49971_1_, String name) {
        super(p_i49971_1_);
        this.name = name;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void randomTick(BlockState state, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!state.canSurvive((LevelReader)pLevel, pPos)) {
            pLevel.destroyBlock(pPos, true);
            return;
        }
        super.tick(state, pLevel, pPos, pRandom);
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 7 && pRandom.nextInt(5) == 0 && pLevel.getRawBrightness(pPos.above(), 0) >= 9) {
            pLevel.setBlock(pPos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.getValue((Property)AGE) < 7;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.nextInt((RandomSource)worldIn.random, (int)2, (int)5);
    }

    public void growFruit(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease((Level)worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.setBlock(pos, this.withAge(i), 2);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.above()).getBlock() instanceof ModLeavesBlock;
    }

    public void performBonemeal(ServerLevel p_225535_1_, RandomSource rand, BlockPos p_225535_3_, BlockState p_225535_4_) {
        this.growFruit(p_225535_1_, rand, p_225535_3_, p_225535_4_);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, WorldGenLevel worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            worldIn.scheduleTick(currentPos, (Block)this, 2);
        }
        return stateIn;
    }
}

