/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlackTeaCropBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private final Supplier<Block> blackTeaCropMiddle;
    private final Supplier<Block> blackTeaCropTop;
    private final Supplier<Block> blackTeaLeaves;

    public BlackTeaCropBlock(Supplier<Block> blackTeaCropMiddle, Supplier<Block> blackTeaCropTop, Supplier<Block> blackTeaLeaves, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.stateDefinition.any());
        this.blackTeaCropMiddle = blackTeaCropMiddle;
        this.blackTeaCropTop = blackTeaCropTop;
        this.blackTeaLeaves = blackTeaLeaves;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, facingState, level, pos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isClientSide && rand.nextFloat() <= 0.1f) {
            worldIn.setBlock(pos.above(), this.blackTeaCropMiddle.get().defaultBlockState(), 3);
            if (worldIn.getBlockState(pos.above()).is(this.blackTeaCropMiddle.get())) {
                worldIn.setBlock(pos.above().above(), this.blackTeaCropTop.get().defaultBlockState(), 3);
                worldIn.setBlock(pos.above().north(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.setBlock(pos.above().south(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.setBlock(pos.above().west(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.setBlock(pos.above().east(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (worldIn.getBlockState(pos.above().above()).is(this.blackTeaCropTop.get())) {
                worldIn.setBlock(pos.above().above().north(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.setBlock(pos.above().above().south(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.setBlock(pos.above().above().west(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.setBlock(pos.above().above().east(), (BlockState)((BlockState)this.blackTeaLeaves.get().defaultBlockState().setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }
}

