/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.node.Node;

public class PropertyNode<T>
extends Node<T> {
    private final String rawPropertyName;
    private final T propertyName;

    public PropertyNode(Adapter<T> runtime, String rawPropertyName) {
        super(runtime);
        this.rawPropertyName = rawPropertyName;
        this.propertyName = runtime.createString(rawPropertyName);
    }

    @Override
    public T search(T input) {
        return this.runtime.getProperty(input, this.propertyName);
    }

    @Override
    protected String internalToString() {
        return this.rawPropertyName;
    }

    @Override
    protected boolean internalEquals(Object o) {
        PropertyNode other = (PropertyNode)o;
        return this.rawPropertyName.equals(other.rawPropertyName);
    }

    @Override
    protected int internalHashCode() {
        return this.rawPropertyName.hashCode();
    }
}

