/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.test;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={JavaSamplerClient.class})
public class SleepTest
extends AbstractJavaSamplerClient
implements Serializable,
Interruptible {
    private static final Logger LOG = LoggerFactory.getLogger(SleepTest.class);
    private static final long serialVersionUID = 240L;
    private static final long DEFAULT_SLEEP_TIME = 1000L;
    private static final long DEFAULT_SLEEP_MASK = 1023L;
    private long sleepTime;
    private long sleepMask;
    private String name;
    private volatile transient Thread myThread;

    public SleepTest() {
        LOG.debug(this.whoAmI() + "\tConstruct");
    }

    @Override
    public void setupTest(JavaSamplerContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.whoAmI() + "\tsetupTest()");
            SleepTest.listParameters(context);
        }
        this.sleepTime = context.getLongParameter("SleepTime", 1000L);
        this.sleepMask = context.getLongParameter("SleepMask", 1023L);
        this.name = context.getParameter("TestElement.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampleResult runTest(JavaSamplerContext context) {
        SampleResult results = new SampleResult();
        results.setSampleLabel(this.name);
        long sleep = this.sleepTime;
        if (this.sleepTime > 0L && this.sleepMask > 0L) {
            long start = System.currentTimeMillis();
            sleep = this.sleepTime + start % this.sleepMask;
        }
        results.setSamplerData("Sleep Test: time = " + sleep);
        try {
            results.sampleStart();
            this.myThread = Thread.currentThread();
            TimeUnit.MILLISECONDS.sleep(sleep);
            this.myThread = null;
            results.setSuccessful(true);
        }
        catch (InterruptedException e) {
            LOG.warn("SleepTest: interrupted.");
            results.setSuccessful(false);
            results.setResponseMessage(e.toString());
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.error("SleepTest: error during sample", (Throwable)e);
            results.setSuccessful(false);
            results.setResponseMessage(e.toString());
        }
        finally {
            results.sampleEnd();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.whoAmI() + "\trunTest()\tTime:\t" + results.getTime());
            SleepTest.listParameters(context);
        }
        return results;
    }

    @Override
    public Arguments getDefaultParameters() {
        Arguments params = new Arguments();
        params.addArgument("SleepTime", String.valueOf(1000L));
        params.addArgument("SleepMask", "0x" + Long.toHexString(1023L).toUpperCase(Locale.ENGLISH));
        return params;
    }

    private static void listParameters(JavaSamplerContext context) {
        Iterator<String> argsIt = context.getParameterNamesIterator();
        while (argsIt.hasNext()) {
            String lName = argsIt.next();
            LOG.debug(lName + "=" + context.getParameter(lName));
        }
    }

    private String whoAmI() {
        return Thread.currentThread().toString() + "@" + Integer.toHexString(this.hashCode());
    }

    public boolean interrupt() {
        Thread t = this.myThread;
        if (t != null) {
            t.interrupt();
        }
        return t != null;
    }
}

