/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.svg.PathUtilKt;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColors;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J&\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/GridComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "majorGrid", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "minorGrid", "gridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;)V", "buildComponent", "", "buildGridLine", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "lineString", "width", "", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "plot-builder"})
public final class GridComponent
extends SvgComponent {
    @NotNull
    private final List<List<DoubleVector>> majorGrid;
    @NotNull
    private final List<List<DoubleVector>> minorGrid;
    @NotNull
    private final PanelGridTheme gridTheme;

    public GridComponent(@NotNull List<? extends List<DoubleVector>> majorGrid, @NotNull List<? extends List<DoubleVector>> minorGrid, @NotNull PanelGridTheme gridTheme) {
        Intrinsics.checkNotNullParameter(majorGrid, (String)"majorGrid");
        Intrinsics.checkNotNullParameter(minorGrid, (String)"minorGrid");
        Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
        this.majorGrid = majorGrid;
        this.minorGrid = minorGrid;
        this.gridTheme = gridTheme;
    }

    protected void buildComponent() {
        SvgNode elem;
        if (this.gridTheme.showMinor()) {
            for (List<DoubleVector> lineString : this.minorGrid) {
                elem = this.buildGridLine(lineString, this.gridTheme.minorLineWidth(), this.gridTheme.minorLineColor());
                this.getRootGroup().children().add((Object)elem);
            }
        }
        if (this.gridTheme.showMajor()) {
            for (List<DoubleVector> lineString : this.majorGrid) {
                elem = this.buildGridLine(lineString, this.gridTheme.majorLineWidth(), this.gridTheme.majorLineColor());
                this.getRootGroup().children().add((Object)elem);
            }
        }
    }

    private final SvgNode buildGridLine(List<DoubleVector> lineString, double width, Color color) {
        SvgShape shapeElem = lineString.size() == 2 ? (SvgShape)new SvgLineElement(lineString.get(0).getX(), lineString.get(0).getY(), lineString.get(1).getX(), lineString.get(1).getY()) : (lineString.size() < 2 ? (SvgShape)new SvgPathElement() : (SvgShape)new SvgPathElement(PathUtilKt.lineString((SvgPathDataBuilder)new SvgPathDataBuilder(false, 1, null), lineString).build()));
        shapeElem.strokeColor().set((Object)color);
        shapeElem.strokeWidth().set((Object)width);
        shapeElem.fill().set((Object)SvgColors.NONE);
        return (SvgNode)shapeElem;
    }
}

