/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.jmeter.gui.util.TristateState;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;

public final class TristateCheckBox
extends JCheckBox {
    private static final long serialVersionUID = 1L;
    private final ChangeListener enableListener = new TSCBChangeListener();

    public TristateCheckBox() {
        this(null, null, TristateState.DESELECTED);
    }

    public TristateCheckBox(String text) {
        this(text, null, TristateState.DESELECTED);
    }

    public TristateCheckBox(String text, boolean selected) {
        this(text, null, selected ? TristateState.SELECTED : TristateState.DESELECTED);
    }

    public TristateCheckBox(String text, Icon icon, TristateState initial) {
        this(text, icon, initial, false);
    }

    TristateCheckBox(String text, Icon icon, TristateState initial, boolean original) {
        super(text, icon);
        this.setModel(new TristateButtonModel(initial, this, original));
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.iterateState();
            }
        });
        ActionMapUIResource actions = new ActionMapUIResource();
        actions.put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TristateCheckBox.this.iterateState();
            }
        });
        actions.put("released", null);
        SwingUtilities.replaceUIActionMap(this, actions);
    }

    public void setTristateFromProperty(TestElement element, String propName) {
        JMeterProperty jmp = element.getProperty(propName);
        if (jmp instanceof NullProperty) {
            this.setIndeterminate();
        } else {
            this.setSelected(jmp.getBooleanValue());
        }
    }

    public void setPropertyFromTristate(TestElement element, String propName) {
        if (this.isIndeterminate()) {
            element.removeProperty(propName);
        } else {
            element.setProperty(propName, this.isSelected());
        }
    }

    public void setIndeterminate() {
        this.getTristateModel().setIndeterminate();
    }

    public boolean isIndeterminate() {
        return this.getTristateModel().isIndeterminate();
    }

    public TristateState getState() {
        return this.getTristateModel().getState();
    }

    @Override
    public void setModel(ButtonModel newModel) {
        super.setModel(newModel);
        if (this.model instanceof TristateButtonModel) {
            this.model.addChangeListener(this.enableListener);
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
    }

    private void iterateState() {
        if (!this.getModel().isEnabled()) {
            return;
        }
        this.grabFocus();
        this.getTristateModel().iterateState();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getText(), System.currentTimeMillis(), modifiers));
    }

    public TristateButtonModel getTristateModel() {
        return (TristateButtonModel)super.getModel();
    }

    private final class TSCBChangeListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = -3718373200229708535L;

        private TSCBChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TristateCheckBox.this.setFocusable(TristateCheckBox.this.getModel().isEnabled());
        }
    }

    private static class TristateButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 1L;
        private TristateState state = TristateState.DESELECTED;
        private final TristateCheckBox tristateCheckBox;
        private final Icon icon;
        private final boolean original;

        public TristateButtonModel(TristateState initial, TristateCheckBox tristateCheckBox, boolean original) {
            this.setState(initial);
            this.tristateCheckBox = tristateCheckBox;
            this.icon = new TristateCheckBoxIcon();
            this.original = original;
        }

        public void setIndeterminate() {
            this.setState(TristateState.INDETERMINATE);
        }

        public boolean isIndeterminate() {
            return this.state == TristateState.INDETERMINATE;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.displayState();
        }

        @Override
        public void setSelected(boolean selected) {
            this.setState(selected ? TristateState.SELECTED : TristateState.DESELECTED);
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setPressed(boolean b) {
        }

        void iterateState() {
            this.setState(this.state.next());
        }

        private void setState(TristateState state) {
            this.state = state;
            this.displayState();
            if (state == TristateState.INDETERMINATE && this.isEnabled()) {
                this.fireStateChanged();
                int indeterminate = 3;
                this.fireItemStateChanged(new ItemEvent(this, 701, this, indeterminate));
            }
        }

        private void displayState() {
            super.setSelected(this.state != TristateState.DESELECTED);
            if (this.original) {
                super.setArmed(this.state == TristateState.INDETERMINATE);
            } else if (this.state == TristateState.INDETERMINATE) {
                this.tristateCheckBox.setIcon(this.icon);
                this.tristateCheckBox.setSelectedIcon(this.icon);
                this.tristateCheckBox.setDisabledSelectedIcon(this.icon);
            } else if (this.tristateCheckBox != null) {
                this.tristateCheckBox.setIcon(null);
                this.tristateCheckBox.setSelectedIcon(null);
                this.tristateCheckBox.setDisabledSelectedIcon(null);
            }
            super.setPressed(this.state == TristateState.INDETERMINATE);
        }

        public TristateState getState() {
            return this.state;
        }
    }

    private static class TristateCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 290L;
        private final int iconHeight;
        private final int iconWidth;

        public TristateCheckBoxIcon() {
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            Icon icon = defaults.getIcon("CheckBox.icon");
            if (icon == null) {
                icon = defaults.getIcon("CheckBox.selected.icon");
            }
            this.iconHeight = icon == null ? 19 : icon.getIconHeight();
            this.iconWidth = icon == null ? 19 : icon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(x, y, this.iconWidth - 1, this.iconHeight - 1);
                    TristateCheckBoxIcon.drawPressed3DBorder(g, x, y, this.iconWidth, this.iconHeight);
                } else {
                    TristateCheckBoxIcon.drawFlush3DBorder(g, x, y, this.iconWidth, this.iconHeight);
                }
                g.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, this.iconWidth - 1, this.iconHeight - 1);
            }
            this.drawLine(g, x, y);
        }

        private void drawLine(Graphics g, int x, int y) {
            int left = x + 2;
            int right = x + (this.iconWidth - 4);
            int height = y + this.iconHeight / 2;
            g.drawLine(left, height, right, height);
            g.drawLine(left, height - 1, right, height - 1);
        }

        private static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawRect(1, 1, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(0, h - 1, 1, h - 2);
            g.drawLine(w - 1, 0, w - 2, 1);
            g.translate(-x, -y);
        }

        private static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            TristateCheckBoxIcon.drawFlush3DBorder(g, 0, 0, w, h);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, 1, w - 2, 1);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }
    }
}

