/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Command.class})
public class OpenLinkAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(OpenLinkAction.class);
    private static final Map<String, String> LINK_MAP = OpenLinkAction.initLinkMap();
    private static final Set<String> commands = new HashSet<String>();

    private static final Map<String, String> initLinkMap() {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("link_bug_tracker:", "https://jmeter.apache.org/issues.html");
        map.put("link_component_reference:", "https://jmeter.apache.org/usermanual/component_reference.html");
        map.put("link_function_reference:", "https://jmeter.apache.org/usermanual/functions.html");
        map.put("link_nightly_build:", "https://jmeter.apache.org/nightly.html");
        map.put("link_release_notes", "https://jmeter.apache.org/changes.html");
        return map;
    }

    @Override
    public void doAction(ActionEvent e) {
        String url = LINK_MAP.get(e.getActionCommand());
        if (url == null) {
            log.warn("Action {} not handled by this class", (Object)e.getActionCommand());
            return;
        }
        try {
            if (e.getSource() instanceof String[]) {
                url = url + "#" + ((String[])e.getSource())[1];
            }
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException err) {
            log.error("OpenLinkAction: User default browser is not found, or it fails to be launched, or the default handler application failed to be launched on {}", (Object)url, (Object)err);
        }
        catch (UnsupportedOperationException err) {
            log.error("OpenLinkAction: Current platform does not support the Desktop.Action.BROWSE action on {}", (Object)url, (Object)err);
            OpenLinkAction.showBrowserWarning(url);
        }
        catch (SecurityException err) {
            log.error("OpenLinkAction: Security problem on {}", (Object)url, (Object)err);
        }
        catch (Exception err) {
            log.error("OpenLinkAction on {}", (Object)url, (Object)err);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    private static void showBrowserWarning(String url) {
        String problemSolver = url.startsWith(LINK_MAP.get("link_component_reference:")) || url.startsWith(LINK_MAP.get("link_function_reference:")) ? "\n\nTry to set the system property help.local to true." : "";
        JOptionPane.showMessageDialog(null, String.format("Problem opening a browser to show the content of the URL%n%s%s", url, problemSolver), "Problem opening browser", 2);
    }

    static {
        commands.add("link_bug_tracker:");
        commands.add("link_component_reference:");
        commands.add("link_function_reference:");
        commands.add("link_nightly_build:");
        commands.add("link_release_notes");
    }
}

