/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.ContinuousTransformWithLimits;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.IdentityTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.LinearBreaksGen;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Log10Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Log2Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.NonlinearBreaksGen;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.ReverseTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.SqrtTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.SymlogTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0016\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aJ\u0018\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/Transforms;", "", "()V", "IDENTITY", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "getIDENTITY", "()Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "LOG10", "getLOG10", "LOG2", "getLOG2", "REVERSE", "getREVERSE", "SQRT", "getSQRT", "SYMLOG", "getSYMLOG", "continuousWithLimits", "actual", "limits", "Lkotlin/Pair;", "", "createBreaksGeneratorForTransformedDomain", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "transform", "labelFormatter", "Lkotlin/Function1;", "", "ensureApplicableDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "dataRange", "BreaksGeneratorForTransformedDomain", "plot-base"})
public final class Transforms {
    @NotNull
    public static final Transforms INSTANCE = new Transforms();
    @NotNull
    private static final ContinuousTransform IDENTITY = new IdentityTransform();
    @NotNull
    private static final ContinuousTransform REVERSE = new ReverseTransform();
    @NotNull
    private static final ContinuousTransform SQRT = new SqrtTransform();
    @NotNull
    private static final ContinuousTransform LOG10 = new Log10Transform();
    @NotNull
    private static final ContinuousTransform LOG2 = new Log2Transform();
    @NotNull
    private static final ContinuousTransform SYMLOG = new SymlogTransform();

    private Transforms() {
    }

    @NotNull
    public final ContinuousTransform getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final ContinuousTransform getREVERSE() {
        return REVERSE;
    }

    @NotNull
    public final ContinuousTransform getSQRT() {
        return SQRT;
    }

    @NotNull
    public final ContinuousTransform getLOG10() {
        return LOG10;
    }

    @NotNull
    public final ContinuousTransform getLOG2() {
        return LOG2;
    }

    @NotNull
    public final ContinuousTransform getSYMLOG() {
        return SYMLOG;
    }

    @NotNull
    public final ContinuousTransform continuousWithLimits(@NotNull ContinuousTransform actual, @NotNull Pair<Double, Double> limits) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(limits, (String)"limits");
        return new ContinuousTransformWithLimits(actual, (Double)limits.getFirst(), (Double)limits.getSecond());
    }

    @NotNull
    public final BreaksGenerator createBreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform, @Nullable Function1<Object, String> labelFormatter) {
        BreaksGenerator breaksGenerator;
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Transform transform2 = transform.unwrap();
        if (Intrinsics.areEqual((Object)transform2, (Object)IDENTITY)) {
            breaksGenerator = new LinearBreaksGen(labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)REVERSE)) {
            breaksGenerator = new LinearBreaksGen(labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)SQRT)) {
            breaksGenerator = new NonlinearBreaksGen(SQRT, labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)LOG10)) {
            breaksGenerator = new NonlinearBreaksGen(LOG10, labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)LOG2)) {
            breaksGenerator = new NonlinearBreaksGen(LOG2, labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)SYMLOG)) {
            breaksGenerator = new NonlinearBreaksGen(SYMLOG, labelFormatter);
        } else {
            throw new IllegalStateException("Unexpected 'transform' type: " + Reflection.getOrCreateKotlinClass(transform.getClass()).getSimpleName());
        }
        BreaksGenerator breaksGenerator2 = breaksGenerator;
        return new BreaksGeneratorForTransformedDomain(transform, breaksGenerator2);
    }

    public static /* synthetic */ BreaksGenerator createBreaksGeneratorForTransformedDomain$default(Transforms transforms, ContinuousTransform continuousTransform, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return transforms.createBreaksGeneratorForTransformedDomain(continuousTransform, (Function1<Object, String>)function1);
    }

    @NotNull
    public final DoubleSpan ensureApplicableDomain(@Nullable DoubleSpan dataRange, @NotNull ContinuousTransform transform) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        if (dataRange == null) {
            return ContinuousTransform.DefaultImpls.createApplicableDomain$default(transform, null, 1, null);
        }
        DoubleSpan domain = transform.toApplicableDomain(dataRange);
        boolean bl = SeriesUtil.INSTANCE.isBeyondPrecision(domain);
        if (bl) {
            doubleSpan = transform.createApplicableDomain(domain.getUpperEnd());
        } else if (!bl) {
            doubleSpan = domain;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return doubleSpan;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/Transforms$BreaksGeneratorForTransformedDomain;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "breaksGenerator", "(Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;)V", "getBreaksGenerator", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "defaultFormatter", "Lkotlin/Function1;", "", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "targetCount", "", "generateBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "labelFormatter", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nTransforms.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transforms.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/Transforms$BreaksGeneratorForTransformedDomain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1549#2:93\n1620#2,3:94\n*S KotlinDebug\n*F\n+ 1 Transforms.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/Transforms$BreaksGeneratorForTransformedDomain\n*L\n84#1:93\n84#1:94,3\n*E\n"})
    public static final class BreaksGeneratorForTransformedDomain
    implements BreaksGenerator {
        @NotNull
        private final ContinuousTransform transform;
        @NotNull
        private final BreaksGenerator breaksGenerator;

        public BreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform, @NotNull BreaksGenerator breaksGenerator) {
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            Intrinsics.checkNotNullParameter((Object)breaksGenerator, (String)"breaksGenerator");
            this.transform = transform;
            this.breaksGenerator = breaksGenerator;
        }

        @NotNull
        public final BreaksGenerator getBreaksGenerator() {
            return this.breaksGenerator;
        }

        @Override
        @NotNull
        public Function1<Object, String> labelFormatter(@NotNull DoubleSpan domain, int targetCount) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            return this.breaksGenerator.labelFormatter(domainBeforeTransform, targetCount);
        }

        @Override
        @NotNull
        public Function1<Object, String> defaultFormatter(@NotNull DoubleSpan domain, int targetCount) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            return this.breaksGenerator.defaultFormatter(domainBeforeTransform, targetCount);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ScaleBreaks generateBreaks(@NotNull DoubleSpan domain, int targetCount) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            ScaleBreaks scaleBreaks = this.breaksGenerator.generateBreaks(domainBeforeTransform, targetCount);
            List<Object> originalBreaks = scaleBreaks.getDomainValues();
            Iterable $this$map$iv = this.transform.apply(originalBreaks);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Double d = (Double)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Double");
                collection.add(it.doubleValue());
            }
            List transformedBreaks = (List)destination$iv$iv;
            return new ScaleBreaks(originalBreaks, transformedBreaks, scaleBreaks.getLabels());
        }
    }
}

