/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui;

import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public final class WidgetPopupHelper {
    public static Rectangle getPopupBounds(JComponent parent, Dimension popupSize, Dimension parentSize) {
        return WidgetPopupHelper.getPopupBounds(parent, popupSize, parentSize, true, false);
    }

    public static Rectangle getPopupBounds(JComponent parent, Dimension popupSize, Dimension parentSize, boolean useParentSizeAsMinimum, boolean alignOpposite) {
        Insets parentIns = parent.getInsets();
        if (useParentSizeAsMinimum) {
            popupSize.width = Math.max(popupSize.width, parentSize.width - parentIns.left - parentIns.right);
        }
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        if (alignOpposite) {
            ltr = !ltr;
        }
        int x = ltr ? parentIns.left : parentSize.width - parentIns.right - popupSize.width;
        return WidgetPopupHelper.computePopupBounds(parent, x, parentSize.height - parentIns.bottom, popupSize.width, popupSize.height);
    }

    protected static Rectangle computePopupBounds(JComponent parent, int px, int py, int pw, int ph) {
        Rectangle screenBounds = DarkUIUtil.getScreenBounds(parent, null);
        Point pos = parent.getLocationOnScreen();
        Insets ins = parent.getInsets();
        Rectangle rect = new Rectangle(pos.x + px, pos.y + py, pw, ph);
        WidgetPopupHelper.adjustYCoordinate(screenBounds, pos, ins, rect);
        WidgetPopupHelper.adjustXCoordinate(screenBounds, rect);
        rect.x -= pos.x;
        rect.y -= pos.y;
        return rect;
    }

    private static void adjustYCoordinate(Rectangle screenBounds, Point pos, Insets ins, Rectangle rect) {
        if (rect.y + rect.height > screenBounds.y + screenBounds.height) {
            if (pos.y - rect.height - ins.top >= screenBounds.y) {
                rect.y = pos.y - rect.height - ins.top;
            } else {
                rect.y = screenBounds.y + Math.max(0, (screenBounds.height - rect.height) / 2);
                rect.height = Math.min(screenBounds.height, rect.height);
            }
        }
    }

    private static void adjustXCoordinate(Rectangle screenBounds, Rectangle rect) {
        if (rect.x < screenBounds.x) {
            rect.width = Math.min(screenBounds.width, rect.width);
            rect.x = screenBounds.x;
        } else if (rect.x + rect.width > screenBounds.width + screenBounds.x) {
            rect.width = Math.min(screenBounds.width, rect.width);
            rect.x = screenBounds.x + screenBounds.width - rect.width;
        }
    }
}

