/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberMath
implements ICSSExpressionMember,
ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSExpressionMathMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberMath() {
    }

    public CSSExpressionMemberMath(@Nonnull Iterable<? extends ICSSExpressionMathMember> iterable) {
        this.m_aMembers.addAll(iterable);
    }

    @Nonnull
    public CSSExpressionMemberMath addMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.notNull((Object)iCSSExpressionMathMember, (String)"Member");
        this.m_aMembers.add((Object)iCSSExpressionMathMember);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberMath addMember(@Nonnegative int n, @Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSExpressionMathMember, (String)"Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add((Object)iCSSExpressionMathMember);
        } else {
            this.m_aMembers.add(n, (Object)iCSSExpressionMathMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        return this.m_aMembers.removeObject((Object)iCSSExpressionMathMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSExpressionMathMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSExpressionMemberMath getClone() {
        return new CSSExpressionMemberMath((Iterable<? extends ICSSExpressionMathMember>)this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("calc(");
        for (ICSSExpressionMathMember iCSSExpressionMathMember : this.m_aMembers) {
            stringBuilder.append(iCSSExpressionMathMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(")").toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMath cSSExpressionMemberMath = (CSSExpressionMemberMath)object;
        return this.m_aMembers.equals(cSSExpressionMemberMath.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

