/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.io.File;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Stream;

public class Converter {
    public static Object convert(Object value, Class<?> toType) {
        Class<?> convertedValue = value;
        if (value == null || toType == null) {
            convertedValue = "";
        } else if (toType.isAssignableFrom(value.getClass())) {
            convertedValue = value;
        } else if (toType.equals(Float.TYPE) || toType.equals(Float.class)) {
            convertedValue = Float.valueOf(Converter.getFloat(value));
        } else if (toType.equals(Double.TYPE) || toType.equals(Double.class)) {
            convertedValue = Converter.getDouble(value);
        } else if (toType.equals(String.class)) {
            convertedValue = Converter.getString(value);
        } else if (toType.equals(Integer.TYPE) || toType.equals(Integer.class)) {
            convertedValue = Converter.getInt(value);
        } else if (toType.equals(Character.TYPE) || toType.equals(Character.class)) {
            convertedValue = Character.valueOf(Converter.getChar(value));
        } else if (toType.equals(Long.TYPE) || toType.equals(Long.class)) {
            convertedValue = Converter.getLong(value);
        } else if (toType.equals(Boolean.TYPE) || toType.equals(Boolean.class)) {
            convertedValue = Converter.getBoolean(value);
        } else if (toType.equals(java.util.Date.class)) {
            convertedValue = Converter.getDate(value);
        } else if (toType.equals(Calendar.class)) {
            convertedValue = Converter.getCalendar(value);
        } else if (toType.equals(File.class)) {
            convertedValue = Converter.getFile(value);
        } else if (toType.equals(Class.class)) {
            try {
                convertedValue = Class.forName(((Object)value).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return convertedValue;
    }

    public static Calendar getCalendar(Object date, Calendar defaultValue) {
        Calendar cal = new GregorianCalendar();
        if (date instanceof java.util.Date) {
            cal.setTime((java.util.Date)date);
            return cal;
        }
        if (date != null) {
            Optional<java.util.Date> d = Converter.tryToParseDate(date);
            if (!d.isPresent()) {
                return defaultValue;
            }
            cal.setTime(d.get());
        } else {
            cal = defaultValue;
        }
        return cal;
    }

    public static Calendar getCalendar(Object o) {
        return Converter.getCalendar(o, new GregorianCalendar());
    }

    public static java.util.Date getDate(Object date) {
        return Converter.getDate(date, Calendar.getInstance().getTime());
    }

    public static java.util.Date getDate(Object date, java.util.Date defaultValue) {
        if (date instanceof java.util.Date) {
            return (java.util.Date)date;
        }
        if (date != null) {
            return Converter.tryToParseDate(date).orElse(defaultValue);
        }
        return defaultValue;
    }

    private static Optional<java.util.Date> tryToParseDate(Object date) {
        return Stream.of(3, 2, 1, 0).map(DateFormat::getDateInstance).map(formatter -> Converter.tryToParseDate(formatter, date.toString())).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static Optional<java.util.Date> tryToParseDate(DateFormat formatter, String dateString) {
        try {
            return Optional.of(formatter.parse(dateString));
        }
        catch (ParseException e) {
            return Optional.empty();
        }
    }

    public static float getFloat(Object o, float defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        try {
            return Float.parseFloat(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float getFloat(Object o) {
        return Converter.getFloat(o, 0.0f);
    }

    public static double getDouble(Object o, double defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            return Double.parseDouble(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double getDouble(Object o) {
        return Converter.getDouble(o, 0.0);
    }

    public static boolean getBoolean(Object o) {
        return Converter.getBoolean(o, false);
    }

    public static boolean getBoolean(Object o, boolean defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public static int getInt(Object o, int defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static char getChar(Object o) {
        return Converter.getChar(o, ' ');
    }

    public static char getChar(Object o, char defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            if (o instanceof Byte) {
                return (char)((Byte)o).byteValue();
            }
            if (o instanceof Integer) {
                return (char)((Integer)o).intValue();
            }
            String s = o.toString();
            if (s.length() > 0) {
                return o.toString().charAt(0);
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(Object o) {
        return Converter.getInt(o, 0);
    }

    public static long getLong(Object o, long defaultValue) {
        try {
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(Object o) {
        return Converter.getLong(o, 0L);
    }

    public static String formatDate(java.util.Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String formatDate(String date, String pattern) {
        return Converter.formatDate(Converter.getCalendar(date, null), pattern);
    }

    public static String formatDate(Calendar date, String pattern) {
        return Converter.formatCalendar(date, pattern);
    }

    public static String formatCalendar(Calendar date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date.getTime());
    }

    public static String getString(Object o, String defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        return o.toString();
    }

    public static String insertLineBreaks(String v, String insertion) {
        if (v == null) {
            return "";
        }
        StringBuilder replacement = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(v, "\n", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.compareTo("\n") == 0) {
                replacement.append(insertion);
                continue;
            }
            replacement.append(token);
        }
        return replacement.toString();
    }

    public static String getString(Object o) {
        return Converter.getString(o, "");
    }

    public static File getFile(Object o) {
        if (o instanceof File) {
            return (File)o;
        }
        if (o instanceof String) {
            return new File((String)o);
        }
        throw new IllegalArgumentException("Expected String or file, actual " + o.getClass().getName());
    }
}

